---
title: "PEGs, Packrats and Parser Combinators"
collection: teaching
type: "Guest lecture"
permalink: /teaching/2023-04-06-PEGs
venue: "University of Bern"
date: 2023-04-06
location: "Bern, Switzerland"
---

This was a guest lecture held on Thursday April 6 for the Masters course on [Compiler Construction](https://seg.inf.unibe.ch/teaching/current/cc/) offered by [Timo Kehrer](https://seg.inf.unibe.ch/people/timo/) at the University of Bern.
The lecture provides an introduction to Parsing Expression Grammars, as a well as a live demo using the PetitParser framework to build an interpreter for a toy programming language.

## Part 1 — Introduction to PEGs and PetitParser
Part 1 consists of a regular lecture consisting of an introduction to Parsing Expression Grammars and related parsing frameworks.
It includes simple example of a hand-crafted PEG written in Java, and an optimized packrat version that caches intermediate results to avoid reparsing during backtracking.


[PDF](/files/slides/2023-04-06-PEGs-CC.pdf)
| [Keynote](https://github.com/onierstrasz/lecture-pegs)
| [Java](https://github.com/onierstrasz/course-compiler-construction/tree/master/examples/cc-SimplePackrat/src)
| [YouTube video](https://youtu.be/MbzE_PonAfQ)

## Part 2 — Implementing SPL in PetitParser

Part 2 consists of a live demo showing the development of an interpreter for SPL, the Simple Programming language used in exercises in the course, using [PetitParser 2](https://scg.unibe.ch/research/helvetia/petitparser), the PEG framework integrated in the [Glamorous Toolkit environment](https://gtoolkit.com).

The demo can be run by [downloading Glamorous Toolkit](https://gtoolkit.com/download/) and running the following code in a Playground:

```
SPLPetitParserSlideshow show 
```

**NB:** There is also extensive documentation of the SPL case study in the Glamorous Toolkit book. Just look for the page called “PetitParser SPL case study” in the table of contents, or search for it with the Spotter search tool.

[YouTube video](https://youtu.be/IGRLcS7Heuw)