Object subclass: #VRDomainEntity
	instanceVariableNames: 'dataset'
	classVariableNames: ''
	package: 'VisualisationReview-Model'!

!VRDomainEntity methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
dataset
	^ dataset! !

!VRDomainEntity methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
dataset: aDataset
	dataset := aDataset! !


VRDomainEntity subclass: #VRAuthor
	instanceVariableNames: 'name papers'
	classVariableNames: ''
	package: 'VisualisationReview-Model'!

!VRAuthor methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
name
	^ name! !

!VRAuthor methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
name: aString
	name := aString! !

!VRAuthor methodsFor: 'accessing' stamp: '1/30/2026 12:25'!
papers
	^ VRPaperGroup withAll: papers! !

!VRAuthor methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
addPaper: aPaper
	papers add: aPaper! !

!VRAuthor methodsFor: 'accessing' stamp: '1/30/2026 13:43'!
coauthors
	^ VRAuthorGroup
		withAll: (((self papers flatCollect: #authors) copyWithout: self) copyWithoutDuplicates
				sortedAs: #name)! !


!VRAuthor methodsFor: 'initialization' stamp: '1/30/2026 10:36'!
initialize
	papers := OrderedCollection new! !


!VRAuthor methodsFor: 'printing' stamp: '1/30/2026 12:25'!
printOn: aStream
	aStream nextPutAll: self name! !


!VRAuthor methodsFor: 'views' stamp: '1/30/2026 12:25'!
gtPapersFor: aView
	<gtView>
	^ aView forward
		title: 'Papers';
		priority: 10;
		object: [ self papers ];
		view: #gtItemsFor:! !

!VRAuthor methodsFor: 'views' stamp: '1/30/2026 13:41'!
gtSummaryFor: aView
	<gtView>
	^ aView columnedList
		title: 'Summary';
		priority: 10;
		items: [ {{'Name'.
					self name}.
				{'# Papers'.
					self papers size}.
				{'# Co-authors'.
					self coauthors size}} ];
		column: 'Key'
			text: #first
			width: 100;
		column: 'Value' text: #second;
		actionUpdateButton! !

!VRAuthor methodsFor: 'views' stamp: '1/30/2026 13:40'!
gtCoauthorsFor: aView
	<gtView>
	^ aView forward
		title: 'Co-Authors';
		priority: 30;
		object: [ self coauthors ];
		view: #gtAuthorsFor:! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VRAuthor class
	instanceVariableNames: ''!

!VRAuthor class methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
named: aName in: aDataset
	^ self new
		name: aName;
		dataset: aDataset;
		yourself! !


Object subclass: #VRDomainEntityGroup
	uses: TGtGroupWithItems
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'VisualisationReview-Model'!









"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VRDomainEntityGroup class
	uses: TGtGroupWithItems classTrait
	instanceVariableNames: ''!












VRDomainEntityGroup subclass: #VRPaperGroup
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'VisualisationReview-Model'!

!VRPaperGroup methodsFor: 'views' stamp: '1/28/2026 13:53'!
gtItemsFor: aView
	<gtView>
	^ aView columnedList
		title: 'Papers';
		items: [ self items ];
		column: 'Index'
			text: [ :eachItem :eachIndex | eachIndex asRopedText foreground: Color gray ]
			width: 45;
		column: 'Title' text: [ :each | each title ];
		column: 'Type' text: [ :each | each type ];
		actionUpdateButton! !


Object subclass: #VRDataset
	instanceVariableNames: 'allJSON selectedJSON paperDict authorDict'
	classVariableNames: ''
	package: 'VisualisationReview-Model'!

!VRDataset methodsFor: 'initialization' stamp: '1/30/2026 09:36'!
allJSON: aDictionary selectedJSON: anotherDictionary
	self allJSON: aDictionary.
	self selectedJSON: anotherDictionary! !

!VRDataset methodsFor: 'initialization' stamp: '1/30/2026 10:36'!
initializeAuthorDict
	| dict |
	dict := Dictionary new.
	self allPapers
		do: [ :p | 
			p authorNames
				do: [ :n | (dict at: n ifAbsentPut: [ VRAuthor named: n in: self ]) addPaper: p ] ].
	^ dict! !


!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
selectedJSON
	^ selectedJSON! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
allJSON
	^ allJSON! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
selectedJSON: aDictionary
	selectedJSON := aDictionary! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
allJSON: aDictionary
	allJSON := aDictionary! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
allPapers
	^ VRPaperGroup withAll: self paperDict values! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
selectedPapers
	^ self allPapers select: #isDesignStudy! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
paperDict
	^ paperDict
		ifNil: [ paperDict := ((self allJSON collect: [ :d | VRPaper for: d in: self ])
					collect: [ :p | p id -> p ]) asDictionary ]! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
authorDict
	^ authorDict ifNil: [ authorDict := self initializeAuthorDict ]! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 13:29'!
authors
	^ VRAuthorGroup withAll: (self authorDict values sortedAs: #name)! !


!VRDataset methodsFor: 'views' stamp: '1/30/2026 09:36'!
gtAllPapersFor: aView
	<gtView>
	^ aView forward
		title: 'All papers';
		priority: 10;
		object: [ self allPapers ];
		view: #gtItemsFor:! !

!VRDataset methodsFor: 'views' stamp: '1/30/2026 09:36'!
gtSelectedPapersFor: aView
	<gtView>
	^ aView forward
		title: 'Selected papers';
		priority: 20;
		object: [ self selectedPapers ];
		view: #gtItemsFor:! !

!VRDataset methodsFor: 'views' stamp: '1/30/2026 13:30'!
gtAuthorsFor: aView
	<gtView>
	^ aView forward
		title: 'Authors';
		priority: 30;
		object: [ self authors ];
		view: #gtAuthorsFor:! !


!VRDataset methodsFor: 'querying' stamp: '1/30/2026 09:36'!
paperWithId: id
	^ self paperDict at: id! !

!VRDataset methodsFor: 'querying' stamp: '1/30/2026 12:25'!
authorNamed: aName
	^ self authorDict at: aName! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VRDataset class
	instanceVariableNames: ''!

!VRDataset class methodsFor: 'instance creation' stamp: '1/30/2026 09:36'!
forAllCSV: aCSVfile andSelectedCSV: anotherCSVFile
	^ self new
		allJSON: (CSV2JSON for: aCSVfile contents) jsonObject
		selectedJSON: (CSV2JSON for: anotherCSVFile contents) jsonObject! !


VRDomainEntity subclass: #VRPaper
	instanceVariableNames: 'data'
	classVariableNames: ''
	package: 'VisualisationReview-Model'!
!VRPaper commentStamp: '<historical>' prior: 0!
I represent a paper (publication) in a Visualization Review dataset.!


!VRPaper methodsFor: 'accessing' stamp: '1/28/2026 13:52'!
data
	^ data! !

!VRPaper methodsFor: 'accessing' stamp: '1/28/2026 13:52'!
type
	^ self data at: 'Type'! !

!VRPaper methodsFor: 'accessing' stamp: '1/28/2026 13:52'!
id
	^ (self data at: 'ID') asNumber! !

!VRPaper methodsFor: 'accessing' stamp: '1/28/2026 13:52'!
title
	^ self data at: 'Title'! !

!VRPaper methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
dataset
	^ dataset! !

!VRPaper methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
dataset: aDataset
	dataset := aDataset! !

!VRPaper methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
authorNames
	^ (self authorFields collect: [ :f | self data at: f ] thenSelect: #isNotEmpty)
		collect: [ :n | n trimBoth: [ :c | c == $" ] ]! !

!VRPaper methodsFor: 'accessing' stamp: '1/30/2026 12:25'!
authors
	^ VRAuthorGroup
		withAll: (self authorNames collect: [ :n | self dataset authorNamed: n ])! !


!VRPaper methodsFor: 'initialization' stamp: '1/28/2026 13:52'!
data: aDictionary
	data := aDictionary! !


!VRPaper methodsFor: 'testing' stamp: '1/28/2026 13:52'!
isDesignStudy
	^ self type = 'Design Study'! !


!VRPaper methodsFor: 'printing' stamp: '1/28/2026 13:52'!
printOn: aStream
	aStream nextPutAll: self title! !


!VRPaper methodsFor: 'views' stamp: '1/28/2026 13:52'!
gtJsonFor: aView
	<gtView>
	^ aView forward
		title: 'JSON';
		object: [ self data ];
		view: #gtItemsFor:! !

!VRPaper methodsFor: 'views' stamp: '1/28/2026 13:52'!
gtSummaryFor: aView
	<gtView>
	^ aView columnedList
		title: 'Summary';
		priority: 10;
		items: [ {{'ID'.
					self id}.
				{'Title'.
					self title}.
				{'Type'.
					self type}.
				{'# Authors'.
					self data at: '# Authors'}.
				{'# Pages'.
					self data at: '# Pages'}.
				{'Is selected'.
					self isDesignStudy}} ];
		column: 'Key'
			text: #first
			width: 100;
		column: 'Value' text: #second;
		actionUpdateButton! !

!VRPaper methodsFor: 'views' stamp: '1/30/2026 12:25'!
gtAuthorsFor: aView
	<gtView>
	^ aView forward
		title: 'Authors';
		priority: 20;
		object: [ self authors ];
		view: #gtAuthorsFor:! !


!VRPaper methodsFor: 'constant' stamp: '1/30/2026 10:36'!
authorFields
	^ #('First Author' 'Second Author' 'Third Author' 'Fourth Author' 'Fifth Author' 'Sixth Author' 'Seven Author' 'Eighth Author' 'Nineth Author' 'Tenth Author' 'Eleventh Author' 'Twelfth Author')! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VRPaper class
	instanceVariableNames: ''!
!VRPaper class commentStamp: '<historical>' prior: 0!
I represent a paper (publication) in a Visualization Review dataset.!


!VRPaper class methodsFor: 'instance creation' stamp: '1/28/2026 13:52'!
for: aDictionary
	^ self new
		data: aDictionary;
		yourself! !

!VRPaper class methodsFor: 'instance creation' stamp: '1/30/2026 09:36'!
for: aDictionary in: aDataset
	^ self new
		data: aDictionary;
		dataset: aDataset;
		yourself! !


VRDomainEntityGroup subclass: #VRAuthorGroup
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'VisualisationReview-Model'!

!VRAuthorGroup methodsFor: 'views' stamp: '1/30/2026 13:41'!
gtAuthorsFor: aView
	<gtView>
	^ aView columnedList
		title: 'Authors';
		priority: 10;
		items: [ self items ];
		column: 'Index'
			text: [ :eachItem :eachIndex | eachIndex asRopedText foreground: Color gray ]
			width: 45;
		column: 'Author'
			text: [ :each | each gtDisplayString ]
			width: 150;
		column: '# Papers'
			text: [ :each | each papers size ]
			width: 80;
		column: '# Co-authors'
			text: [ :each | each coauthors size ]
			width: 80;
		actionUpdateButton! !
Object subclass: #VRDatasetExamples
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'VisualisationReview-Examples'!

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 13:52'!
allPapersJSON
	<gtExample>
	| json |
	json := (CSV2JSON
			for: (self datasetFolder / 'dataset-review-vissoft-all.csv') contents)
			jsonObject.
	self assert: json size equals: 346.
	^ json! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 13:52'!
datasetFolder
	<gtExample>
	| folder |
	folder := FileLocator gtResource / 'feenkcom' / 'gtoolkit-demos'
			/ 'data' / 'visualisation-review'.
	self assert: folder exists.
	self assert: (folder allChildrenMatching: '*.csv') size equals: 2.
	^ folder! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 13:52'!
selectedPapersJSON
	<gtExample>
	| json |
	json := (CSV2JSON
			for: (self datasetFolder / 'dataset-review-vissoft-selected.csv') contents)
			jsonObject.
	self assert: json size equals: 65.
	^ json! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 13:52'!
allPapers
	<gtExample>
	| papers |
	papers := self allPapersJSON collect: [ :data | VRPaper for: data ].
	self assert: papers size equals: 346.
	^ papers! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 13:52'!
designStudies
	<gtExample>
	| papers |
	papers := self allPapers select: #isDesignStudy.
	self assert: papers size equals: 65.
	^ papers! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 13:52'!
allPapersWrapped
	<gtExample>
	| papers |
	papers := VRPaperGroup withAll: self allPapers.
	self assert: papers size equals: 346.
	^ papers! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/30/2026 09:36'!
vrDataset
	<gtExample>
	^ VRDataset
		forAllCSV: self datasetFolder / 'dataset-review-vissoft-all.csv'
		andSelectedCSV: self datasetFolder / 'dataset-review-vissoft-selected.csv'! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/30/2026 12:25'!
authorLanza
	<gtExample>
	| dataset author |
	dataset := self vrDataset.
	author := dataset authorNamed: 'Lanza, M.'.
	self assert: author name equals: 'Lanza, M.'.
	self assert: author papers size equals: 18.
	^ author! !


!VRDatasetExamples methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
paper128
	<gtExample>
	| paper |
	paper := self vrDataset paperWithId: 128.
	self assert: paper id equals: 128.
	self assert: paper isDesignStudy.
	^ paper! !
