---
title: Past and upcoming events
permalink: /past/
author_profile: true
---

## Upcoming events

- *PC Member* of [SLE 2023](https://www.sleconf.org/2023/) (ACM SIGPLAN International Conference on Software Language Engineering &mdash; Cascais, Portugal, co-located with [SPLASH 2023](https://2023.splashcon.org) Oct. 22-27, 2023)

## Past events (1998-present)

See also: [Dagstuhls I have attended](/dagstuhl).

## 2023

- *Speaker* at [ESUG 2023](https://esug.github.io/2023-Conference/conf2023.html) (European Smaltalk Users Group, Lyon, Aug. 28 - Sep. 1, 2023) — [Teaching Moldable Development](/posts/2023-08-28-TeachingMoldableDevelopment)

- *Invited Speaker* at [BATbern50](https://www.berner-architekten-treffen.ch) (Jubiläums-BAT 50, Paul-Klee Center, Bern, 14h30-19h00, Jun. 9, 2023) — [Mind the gap — 50 years of shortening feedback loops](/talks/2023-06-09-MindTheGap-BATbern50)

- *Guest lecturer* at University of Bern, May 12, 2023 — [A bit of Smalltalk](/teaching/2022-05-20-ABitOfSmalltalk)

- *Guest lecturer* at University of Bern, April 6, 2023 — [PEGs, Packrats and Parser Combinators](/teaching/2023-04-06-PEGs)

## 2022

- *Guest lecturer* at University of Bern, May 20, 2022 — [A bit of Smalltalk](/teaching/2022-05-20-ABitOfSmalltalk)

- *Keynote Speaker* for [VISSOFT 2022](https://vissoft.info/2022/) (10th IEEE Working Conference on Software Visualization &mdash; Limmasol, Cyprus, Oct. 2-3, 2022) — [Making Systems Explainable](/talks/2022-10-03-VISSOFT-MakingSystemsExplainable)

## 2021

- *PC Member* of [ICSME 2021](https://icsme2021.github.io) (37th International Conference on Software Maintenance and Evolution &mdash; Luxembourg City, Sept. 27 - Oct. 1, 2021)

## 2020

-  Keynote Speaker at [ASE 2020 Doctoral Symposium](https://conf.researchr.org/track/ase-2020/ase-2020-doctoral-symposium) (35th IEEE/ACM International Conference on Automated Software Engineering &mdash; Melbourne, Australia, Sept. 21, 2020) — [Taming your PhD](/talks/2020-09-21-TamingYourPhD-ASE2020)
- *PC Member* of [SANER 2020](https://saner2020.csd.uwo.ca) (27th IEEE International Conference on Software Analysis, Evolution and Reengineering - London, Ontario, Canada, Feb. 18-21, 2020)

## 2019

- *General Chair* of [SLE 2019](https://conf.researchr.org/home/sle-2019) (ACM SIGPLAN International Conference on Software Language Engineering &mdash; Athens, Greece, Oct. 21-22, 2019)
- *PC Member* of [SANER 2019](https://saner2019.github.io) (International Conference on Software Analysis, Evolution, and Reengineering &mdash; Hangzhou, People's Republic of China, February 24-27, 2019)

## 2018

- *PC Member* of [SCAM 2018](http://www.ieee-scam.org/2018/) (18th IEEE International Working Conference on Source Code Analysis and Manipulation &mdash; Madrid, Spain, Sept. 23-24, 2018)
- *PC Member* of [SANER 2018](http://saner.unimol.it) (International Conference on Software Analysis, Evolution, and Reengineering &mdash; Campobasso, Italy, March 19-23, 2018)

## 2017

- *PC Member* of [BENEVOL 2017](http://ansymore.uantwerpen.be/events/benevol2017) (16th BElgian-NEtherlands software eVOLution symposium &mdash; University of Antwerp, Belgium, Dec 4-5, 2017)
- *Invited Speaker* at [Simula 50 Years](https://www.mn.uio.no/ifi/personer/vit/dag/simula67/50years/) (50 years anniversary of Simula, the first object-oriented programming language &mdash; Oslo, Norway, Sept. 27, 2017) — [Great Moments in the History of OOP](/talks/2017-09-27-Simula50-GreatMomentsInTheHistoryOfOOP)
- *PC Member* of [ICSME 2017](https://icsme2017.github.io) (International Conference on Software Maintenance and Evolution &mdash; Shanghai, China, Sept. 17-23, 2017)
- *PC Member* of [SANER 2017](http://saner.aau.at) (International Conference on Software Analysis, Evolution, and Reengineering &mdash;  Klagenfurt, Austria, Feb. 21-24, 2017)

## 2016

- *General Co-Chair* for [SCAM 2016](http://www.ieee-scam.org/2016/) (International Working Conference on Source Code Analysis and Manipulation &mdash; Raleigh, North Carolina, Oct. 2-3, 2016)
- *PC Member* of [ICSME 2016](http://icsme2016.github.io) (International Conference on Software Maintenance and Evolution &mdash; Raleigh, North Carolina, Oct. 2-10 2016)
- *PC Member* of [Onward! 2016 Essays Track](http://conf.researchr.org/track/onward2016/onward2016-essays) (Splash / Onward! 2016 &mdash;  Amsterdam, The Netherlands, Oct. 30 - Nov. 4, 2016)
-  *Invited Speaker* at [SATToSE 2016](http://sattose.org/2016/) (9th Seminar Series on Advanced Techniques &amp; Tools for Software Evolution &mdash; Bergen, Norway, July 11&mdash;13, 2016)
-  *Co-organizer* of [Engineering Academic Software](http://www.dagstuhl.de/en/program/calendar/semhp/?semnr=16252) (Dagstuhl Perspectives Workshop 16252 &mdash; Dagstuhl, Germany, June 19-24, 2016)
-  *Invited Speaker* at [FASE-ETAPS 2016](http://www.etaps.org/index.php/2016/fase) (19th International Conference on Fundamental Approaches to Software Engineering (FASE) &mdash; Eindhoven, The Netherlands, April 4-7, 2016) — [The Death of Object-Oriented Programming](/talks/2016-04-13-TheDeathOfOOP-FASE2016)
- *PC Member* of [SANER 2016](http://saner.inf.usi.ch) (International Conference on Software Analysis, Evolution, and Reengineering &mdash;  Osaka, Japan, March 14-18, 2016)

## 2015

- *PC Member* of [BENEVOL 2015](http://www.cristal.univ-lille.fr/benevol2015/benevol.html) (BElgian-NEtherlands software eVOLution seminar &mdash;  Lille, France, Dec 3-4, 2015)
- *PC Member* of [ICSME 2015](http://www.icsme.uni-bremen.de/) (International Conference on Software Maintenance and Evolution &mdash;  Bremen, Germany, Sept 27-Oct 3, 2015)
- *PC Member* of [ICSE 2015](http://2015.icse-conferences.org) (37th International Conference on Software Engineering &mdash; Florence, Italy, May 16-24, 2015)
- *PC Member* of Modularity 2015 Visions Track (International Conference on Modularity &mdash;  Fort Collins, Colorado, March 16-19, 2015)
- *PC Member* of [SANER 2015 ERA Track](http://saner.soccerlab.polymtl.ca/doku.php?id=en:era_track) (International Conference on Software Analysis, Evolution, and Reengineering &mdash;  Montreal, Canada, March 2-6, 2015)

## 2014

-  *Invited Speaker* at INRIA Lille: Domain-Specific Tooling (Nov. 20, 2014)
- *PC Member* of [DLS 2014](http://www.dynamic-languages-symposium.org/dls-14/index.html) (Dynamic Languages Symposium &mdash; colocated with [SPLASH 2014](http://splashcon.org/2014) &mdash; Portland, US, Oct 21, 2014)
- *PC Member* of [SLE 2014](http://www.sleconf.org/2014/) (7th International Conference on Software Language Engineering &mdash;  Västerås, Sweden, Sept 14-15, 2014)
- *PC Member* of CSMR-WCRE-ERA (European Conference on Software Maintenance and Reengineering/Working Conference on Reverse Engineering &mdash; Antwerp, Belgium, Feb 3-7, 2014)

## 2013

- *Keynote Speaker* at [SCAM 2013](http://www.ieee-scam.org/2013/program.html) (13th IEEE International Working Conference on Source Code Analysis and Manipulation &mdash; Eindhoven, The Netherlands, 22-23 September 2013)
- *PC Member* of [ICSM 2013](http://icsm2013.tue.nl/) (29th International Conference on Software Maintenance &mdash; Eindhoven, The Netherlands, Sept 22-28, 2013)
- *Co-organizer* of [SATToSE 2013](http://sattose.org/sattose2013) (6th Seminar on Advanced Techniques & Tools for Software Evolution &mdash; Bern, Switzerland, July 8-10, 2013)
- *Keynote Speaker* at [ECOOP 2013](http://www.lirmm.fr/ecoop13/) (27th European Conference on Object-Oriented Programming &mdash; Montpellier, France, July 1-5, 2013)
- *Keynote Speaker* and *PC Member* of COOMPL 2013 ( Second International Workshop on Combined Object-Oriented Modeling and Programming Languages, colocated with [ECOOP 2013](http://www.lirmm.fr/ecoop13/) &mdash; Montpellier, France, July 1, 2013)
- *PC Member* of [WASDeTT-4 2013](http://wasdett.org/2013/) (International Workshop on Advanced/Academic Software Development Tools and Techniques, colocated with [ECOOP 2013](http://www.lirmm.fr/ecoop13/) &mdash; Montpellier, France, July 1, 2013)
- *PC Member* of [SC 2013](http://sc2013.ec-spride.de/) (International Conference on Software Composition 2013 &mdash; Budapest, Hungary, June 19, 2013)
- *Keynote Speaker* at [Karlsruher Entwicklertag 2013](http://www.entwicklertag.de/) (Karlsruhe, Germany, June 5-7, 2013)
- *PC Member* of [XP 2013](http://xp2013.org/) (14th International Conference on Agile Software Development &mdash; Vienna, Austria, June 3-7, 2013)
- *PC Member* of [ICSE NIER 2013](http://2013.icse-conferences.org/content/new-ideas-and-emerging-results-nier) (New Ideas and Emerging Results &mdash; San Francisco, USA, May 18-26 2013)
- *PC Member* of LIVE 2013 ( First International Workshop on Live Programming, colocated with [ICSE 2013](http://2013.icse-conferences.org/) &mdash; San Francisco, USA, May 19, 2013)
- *Co-organizer* of [PharoConf/MooseDay 2013](https://scg.unibe.ch/wiki/events/pharoconf-mooseday-2013) (Pharo Conference &mdash; Bern, Switzerland, April 2-4 2013)
- *PC Member* of [SE 2013](http://www.se2013.rwth-aachen.de/) (Software Engineering 2013 &mdash; Aachen, Germany, Feb 26 - March 1, 2013)

## 2012

- *Keynote Speaker* at BENEVOL 2012 (11th BElgian-NEtherlands software eVOLution symposium &mdash; Delft, The Netherlands, Dec 3-4, 2012)
- *PC Member* of XM 2012 (Extreme Modeling Workshop, colocated with [Models 2012](http://models2012.info/) &mdash; Innsbruck, Austria, Oct 1, 2012)
- *PC Member* of [GPCE 2012](http://program-transformation.org/GPCE12) (Generative Programming and Component Engineering &mdash; Dresden, Germany, Sept 26-28, 2012)
- *PC Member* of SLE 2012 Doctoral Symposium (At Software Language Engineering &mdash; Dresden, Germany, Sept 25, 2012)
- *PC Member* of [ICSM 2012](http://selab.fbk.eu/icsm2012/) (28th IEEE International Conference on Software Maintenance &mdash; Riva del Garda, Italy, Sept 23-30, 2012)
- *Keynote speaker* at [ICPC 2012](http://icpc12.sosy-lab.org/) (20th IEEE International Conference on Program Comprehension &mdash; Passau, Germany, June 11-13, 2012)
- *PC Member* of [ICPC 2012](http://icpc12.sosy-lab.org/) (20th IEEE International Conference on Program Comprehension &mdash; Passau, Germany, June 11-13, 2012)
- *[Tutorials Co-Chair](http://www.ifi.uzh.ch/icse2012/call-for-contributions/tutorial-and-technical-briefing-proposals/)* for [ICSE 2012](http://www.ifi.uzh.ch/arvo/req/events/ICSE2012/) (34th International Conference on Software Engineeering &mdash; Zurich, Switzerland, June 2-9, 2012)
- *PC Member* of [XP2012](http://www.xp2012.org/) (XP2012 Theme: Agile By Design &mdash; Malmö, Sweden, May 21-25 2012)
- *PC Member* of [SE 2012](http://se2012.swt.tu-berlin.de/) (Software Engineering 2012 &mdash; Berlin, Germany, Feb 27 - March 2, 2012)
-  *PC Member* of Smalltalk Directions (Colocated with [Smalltalk Industry Conference '12](http://www.stic.st/conferences/stic12/) &mdash; Biloxi, Mississippi, USA, March 19-21, 2012)
-  *Keynote Speaker* at [IWRE 2012](http://iwre.cdacmumbai.in/) (3rd India Workshop on Reverse Engineering, co-located with [ISEC '12](http://www.csi-sigse.org/isec2012/) &mdash; Kanpur, India, Feb 22, 2012)
-  *PC Member* of [C5](http://www.cm.is.ritsumei.ac.jp/c5-12/index.php/Home) (The Tenth International Conference on Creating, Connecting and Collaborating through Computing &mdash; U Southern California, USA, Jan 18-20, 2012)

## 2011

- *External Review Committee Member* of [OOPSLA 2011](http://splashcon.org/2011/cfp/100) (SPLASH/OOPSLA &mdash; Portland Oregon, USA, Oct 22-27, 2011)
- *PC Member* of [Onward! 2011](http://onward-conference.org/2011/papers-call.html) (ACM Conference on New Ideas in Programming and Reflections on Software, colocated with [SPLASH/OOPSLA](http://splashcon.org/2011/) &mdash; Portland, Oregon, USA, Oct 22-27 2011)
- *PC Member* of ICSM 2011 (27th IEEE International Conference on Software Maintenance &mdash; Williamsburg, VA, USA, Sept 25 - Oct 1, 2011)
- *PC Member* [GTTSE Summer School](http://gttse.wikidot.com/) (Generative & Transformational Techniques in Software Engineering &mdash; Braga, PT, July 3-9, 2011)
- *Keynote speaker* for [TOOLS 2011](http://toolseurope2011.lcc.uma.es/) (49th International Conference on Objects, Models, Components and Patterns &mdash; Zurich, Switzerland, 27 June - 01 July 2011)
- *PC Member* for [ICMT 2011](http://www.model-transformation.org/) (International Conference on Model Transformation &mdash; Zurich - Switzerland, 27 - 28 June, 2011)
- *PC Member* of [OOPS 2011](http://oops.disi.unige.it/OOPS11/) (Special track on Object-Oriented Programming Languages and Systems at [SAC 2011](http://www.acm.org/conferences/sac/sac2011/) &mdash; Tunghai University, TaiChung, Taiwan, Mar 21-25, 2011
- *PC Member* of [CSMR 2011](http://se.uni-oldenburg.de/csmr2011/index.html) (5th European Conference on Software Maintenance and Reengineering &mdash; Oldenburg, Germany, March 1&mdash;4, 2011)
- *PC Member* of [SE 2011](http://se2011.ipd.kit.edu/) (Software Engineering 2011 &mdash; Karlsruhe, Germany, Feb 21&mdash;25 2011)
- *PC Member* of [C5](http://www.cm.is.ritsumei.ac.jp/c5-11/) (The Ninth International Conference on Creating, Connecting and Collaborating through Computing &mdash; Kyoto University, Kyoto, Japan, 18-20 January 2011)
- *Co-organizer* of [FOSD Dagstuhl Workshop](http://www.dagstuhl.de/de/programm/kalender/semhp/?semnr=11021) (Feature-Oriented Software Development &mdash; Schloss Dagstuhl, Germany, January 9-14, 2011)

## 2010

- *PC Member* of PCODA 2010 (Program Comprehension through Dynamic Analysis (PCODA) workshop &mdash; Colocated with [WCRE 2010](http://web.soccerlab.polymtl.ca/wcre2010/), Beverly, MA, USA, Oct 13-16, 2010)
- *Co-organizer* of [FOSD 20010](http://www.fosd.de/2010) (2nd Workshop on Feature-Oriented Software Development &mdash; Colocated with [GPCE'10](http://program-transformation.org/GPCE10)/SLE 2010, Eindhoven, The Netherlands, Oct 10, 2010)
- *PC Member* of [ICSM 2010](http://icsm2010.upt.ro/) (26th IEEE International Conference on Software Maintenance &mdash; Timişoara, Romania, Sept 12-18, 2010)
- *Co-Chair* of [ICSM 2010 Doctoral Symposium](http://icsm2010.upt.ro/) (Special Track of [ICSM 2010](http://icsm2010.upt.ro/) &mdash; Timişoara, Romania, Sept 13, 2010)
- *PC Member* of [SEAA-EDISON 2010](http://seaa2010.liacs.nl/) (Euromicro Special track on Evolution of Distributed, Internet-based and Service-Oriented applicatioNs &mdash; Lille, France, Sept. 1, 2010
- *PC Member* of [TOOLS 2010](http://malaga2010.lcc.uma.es/) (48th International Conference on Objects, Models, Components, Patterns &mdash; Malaga, Spain, June 28 - July 2, 2010)
- *PC Member* of RAM-SE 2010 (7th ECOOP Workshop on Reflection, AOP and Meta-Data for Software Evolution, colocated with [ECOOP 2010](http://ecoop2010.uni-mb.si/) &mdash; Maribor, Slovenia, July 22, 2010)
- *PC Member* of [Suite 2010](https://scg.unibe.ch/wiki/events/suite2010) (2nd Intl. Workshop on Search-driven development: Users, Infrastructure, Tools and Evaluation. Colocated with ICSE 2010,  Cape Town, South Africa, May 1st, 2010)
- *PC Member* of [WETSoM 2010](http://www.rcost.unisannio.it/wetsom2010/Home.html) (Workshop on Emerging Trends in Software Metrics. Colocated with ICSE 2010,  Cape Town, South Africa, May 4th, 2010)
- *PC Member* of [OOPS 2010](http://oops.disi.unige.it/OOPS10/) (Special track on Object-Oriented Programming Languages and Systems at [SAC 2010](http://www.acm.org/conferences/sac/sac2010/) &mdash; Sierre/Lausanne, Switzerland, Mar 22-26, 2010
- *Invited Speaker* at [SOFSEM 2010](http://www.sofsem.cz/sofsem10/) (36th International Conference on Current Trends in Theory and Practice of Computer Science,  Principles of Software Construction track &mdash; Špindlerův Mlýn, Czech Republic, January 23&mdash;29, 2010)

## 2009

- *Invited Speaker* on Die Evolution von Programmiersprachen in the Collegium Generale lecture series [Wovon man nicht sprechen kann, darüber muss man schweigen: Natürliche und formale Sprachen in den Wissenschaften](http://www.collegiumgenerale.unibe.ch/content/vorlesungsreihen/vorlesungsreihe_sprachen/index_ger.html) (University of Bern &mdash; Oct 28, 2009)
- *PC Member* of [FAMOOSr 2009](http://moose.unibe.ch/events/famoosr2009) (3rd Workshop on FAMIX and Moose in Reengineering; Colocated with  [WCRE 2009](http://web.soccerlab.polymtl.ca/wcre2009/), Lille, France, Oct 13-16, 2009)
- *PC Member* of [FOSD 2009](http://www.infosun.fim.uni-passau.de/cl/staff/apel/FOSD2009/index.html) (1st International Workshop on Feature-Oriented Software Development &mdash; Colocated with [Models](http://www.modelsconference.org/)/[GPCE](http://www.hope.cs.rice.edu/twiki/bin/view/GPCE09/WebHome)/SLE 2009, Denver CO, USA, Oct 4-6 2009)
- *PC Member* of [IWST09](http://www.esug.org/Conferences/2009/InternationalWorkshop) (International Workshop on Smalltalk Technologies &mdash; Colocated with [ESUG 2009](http://www.esug.org/Conferences/2009/), Brest, France, Aug 31, 2009)
- *Program Chair* of [CASTA 2009](http://casta.unibe.ch/) (Workshop on Context-Aware Software Technology and Applications &mdash; Colocated with [ESEC/FSE 2009](http://www.esec-fse-2009.ewi.tudelft.nl/), Amsterdam, The Netherlands, August 24, 2009)
- *PC Member* of the [ESEC/FSE 2009 Doctoral Symposium](http://www.esec-fse-2009.ewi.tudelft.nl/node/20) (At [ESEC/FSE 2009](http://www.esec-fse-2009.ewi.tudelft.nl/), Amsterdam, The Netherlands, August 25, 2009)
- *PC Member* of RAM-SE 2009 (Workshop on Reflection, AOP and Meta-Data for Software Evolution, colocated with [ECOOP 2009](http://2009.ecoop.org/index.html) &mdash; Genova, Italy, July 7, 2009)
- *PC Member* of [ECOOP 2009](http://2009.ecoop.org/index.html) (23rd European Conference on Object-Oriented Programming &mdash; Genova, Italy, July 6-10 2009)
- *PC Member* of [ETSM 2009](http://www.xp2009.org/etsm2009/) (First International Symposium on Emerging Trends in Software Metrics &mdash; Colocated with [XP 2009](http://www2.xp2009.org/xp2009/), Pula, Sardinia, Italy, May 26, 2009)
- *PC Member* of [SUITE 2009](http://smallwiki.unibe.ch/suite2009/) (First Intl. Workshop on Search-Driven Development &mdash; Users, Infrastructure, Tools and Evaluation &mdash; Colocated with [ICSE 2009](http://www.cs.uoregon.edu/events/icse2009/home/), Vancouver, Canada, May 16 2009)

## 2008

- *PC Member* of [Models&#64;run.time](http://www.comp.lancs.ac.uk/~bencomo/MRT/) (Colocated with [Models 2008](http://www.modelsconference.org/) &mdash; Toulouse, France, Sept 28-Oct 3, 2008)
- *PC Member* of [FAMOOSr 2008](http://moose.unibe.ch/events/famoosr2008) (2nd Workshop on FAMIX and Moose in Reengineering &mdash; Colocated with WCRE 2008 &mdash; Antwerp, Belgium, Oct. 17, 2008)
- *PC Member* of [OOPSLA Onward! 2008](http://www.oopsla.org/) (Object-Oriented Programming Systems, Languages and Applications &mdash; Nashville, US, Oct. 19-23, 2008)
- *Invited Speaker* at [SVPP 2008](http://prog.vub.ac.be/svpp08/index.html) (Software Variability: a Programmers' Perspective &mdash; Brussels, Belgium, August 8-9, 2008)
- *PC Member* of DLS 2008 (Dynamic Languages Symposium &mdash; Paphos, Cyprus, July 8, 2008)
- *PC Member* of [WASDeTT 2008](http://smallwiki.unibe.ch/wasdett2008/) (International Workshop on Advanced Software Development Tools and Techniques &mdash; Paphos, Cyprus, July 8, 2008)
- *PC Member* of [TOOLS Europe 2008](http://tools.ethz.ch/index.html) (International Conference on Objects, Models, Components, Patterns &mdash; Zurich, Switzerland, June 30 - July 4, 2008)
- *PC Member* of [ICPC 2008](http://www.cs.vu.nl/icpc2008/) (International Conference on Program Comprehension &mdash; Amsterdam, The Netherlands, 10-13 June, 2008)
- *PC Member* of [FASE 2008](http://www.cs.le.ac.uk/events/fase2008/) (Fundamental Approaches to Software Engineering &mdash; Budapest, Hungary, 29 March - 6 April, 2008)

## 2007

-  President of [CHOOSE](http://www.choose.s-i.ch/), 2003-2007 *(Swiss special interest group on OO Systems)*
- *Co-organized* the [CHOOSE Forum 2007](http://www.choose.s-i.ch/Events/forum2007.html) (Languages for the Web &mdash; FHNW Brugg, Nov. 9, 2007)
- *PC Member* of [DLS 07](http://www.swa.hpi.uni-potsdam.de/dls07/) (Dynamic Languages Symposium 2007 &mdash; colocated with [OOPSLA 07](http://2007.ecoop.org/), Montreal, Oct. 22, 2007)
- *PC Member* of [Dyla07](http://dyla2007.unibe.ch/) (3rd Workshop on Dynamic Languages and Applications &mdash; colocated with [ECOOP 07](http://2007.ecoop.org/), Berlin, July 31, 2007)
- *PC Member* of [TOOLS &mdash; Europe 2007](http://tools.ethz.ch/) (ETH Zurich, June 24-28, 2007)
- *PC Member* of [FAMOOSr Workshop](http://smallwiki.unibe.ch/moose/famoosr2007) (colocated with [TOOLS &mdash; Europe 2007](http://tools.ethz.ch/), ETH Zurich, June 25, 2007)
- *PC Member* of [Coordination 2007](http://www.discotec07.cs.ucy.ac.cy/) (International Conference on Coordination Models and Languages &mdash; Nicosia, Cyprus, June 6-8, 2007)
- *Keynote Speaker* at [ASWEC 2007](http://aswec07.cs.latrobe.edu.au/) (18th Australian Conference on Software Engineering &mdash; Melbourne, April 10-13, 2007)
- *Tutorial Speaker* at [ASWEC 2007](http://aswec07.cs.latrobe.edu.au/tutorials.html) (18th Australian Conference on Software Engineering &mdash; Melbourne, April 10, 2007)
- *Steering Committee Member* of [SC 2007](http://ssel.vub.ac.be/sc2007/) (Software Composition 2007 &mdash;satellite event of [ETAPS 2007](http://www.di.uminho.pt/etaps07/) &mdash; Braga, Portugal, March 24-25, 2007)
- *Invited speaker*, [Swinburne University and SANM](http://www.sanm.id.au/event_2007_03_23.html) ([Hawthorn Campus](http://www.swinburne.edu.au/cwis/maps/maps_hawthorn.htm) &mdash; March 23, 2007)
- *Speaker* at [JUGS event](http://www.jugs.ch/html/events/2007/oo_reengineering_patterns.html): "Object-oriented Reengineering Patterns &mdash; an Overview" (Technopark Zurich, Jan. 25, 2007 &mdash; *[ppt slides](https://www.iam.unibe.ch/scg/svn_repos/Talks/OORP/JUGS2007/JUGS2007.ppt) are available*)

## 2006

- *PC Member* of DLS 2006 (Dynamic Languages Symposium 2006 [at [OOPSLA 2006](http://www.oopsla.org/2006/)] &mdash; Portland, Oregon, Oct. 22, 2006)
- *Participant* at [euroTICS 2006](http://www.eurotics.org/euroTICS2006.html) (European University and Research Organization for the Technologies of Informatics and Computer Science &mdash; Zurich, Oct. 16-17, 2006)
- *Program Chair* of [MoDELS 2006](http://www.modelsconference.org/) (9th International Conference on Model Driven Engineering Languages and Systems &mdash; Genoa, Italy, Oct 1-6, 2006)
- *Keynote speaker* at [NODe 2006](http://www.netobjectdays.org/en/index.html) (NET.ObjectDays 2006 &mdash; Erfurt, Germany, Sept. 18-21, 2006)
- *Participant* and coauthor at ISC 2006 (14th International Smalltalk Conference &mdash; Prague, Czech Republic, Sept. 4-8) 
- *Participant* at the Revival of Dynamic Languages Workshop (RDL06 workshop at [ECOOP 06](http://www.emn.fr/x-info/ecoop2006/index.html) &mdash; Nantes, July 3, 2006)
- *Participant* in the [Dagstuhl Seminar on Latently-Typed Languages](http://www.dagstuhl.de/06181/) (Dagstuhl Seminar 06181 &mdash; Schloss Dagstuhl, May 1-6, 2006)
- *PC Member* of [EVOL 2006](http://w3.umh.ac.be/evol/meetings/evol2006.html) (International ERCIM Workshop on Software Evolution &mdash; Lilles, France, April 6-7, 2006)
- *Steering Committee Member* [SC 2006](http://www.emn.fr/x-info/obasco/events/sc06/) (Software Composition 2006 &mdash; Vienna, Austria, March 25-26, 2006)
- *Co-organizer* of [SARIT 06](http://www.sarit.ch/events/sarit06.html) (SARIT 06: new ways of CS education on all levels &#8212; Uni Basel, March 2, 2006)

## 2005

- *Participant* in [European Computer Science Summit](http://se.inf.ethz.ch/events/cs_summit_2005/) &#8212; ETH Zürich, Oct. 20-21, 2005
- *PC Member* of [DLS05](http://decomp.ulb.ac.be:8082/events/dls05/) (Dynamic Languages Symposium at [OOPSLA 2005](http://www.oopsla.org/2005/ShowPage.do?id=Home) &#8212; San Diego, Oct 18, 2005)
- *Hosting* the [Eclipse RCP Workshop](http://www.bsiag.com/eclipse/rcp05) &#8212; U. Bern, Oct. 17, 2005
- *PC Member* of [ MoDELS / UML 2005](http://www.modelsconference.org/) (ACM/IEEE 8th International Conference on Model Driven Engineering Languages and Systems &#8212; Jamaica, Oct 2-7, 2005)
- *Invited Speaker* at [GPCE'05](http://gpce.org/05) (Generative Programming and Component Engineering &#8212; Tallinn, Estonia, Sep 29 - Oct 1, 2005)
- *Invited Speaker* at [ESEC/FSE'05](http://esecfse05.unl.pt/) (European Software Engineering Conference &#8212; Lisbon, Portugal, Sept. 5-9, 2005)
- *PC Member* of [IWPSE '05](http://www.rcost.unisannio.it/iwpse2005/index.htm) (International Workshop on Principles of Software Evolution &#8212; Lisbon, Portugal, Sept. 5-6, 2005)
- *PC Member* of the Euromicro CBSE Track (31st Euromicro &#8212; Porto, Portugal, Aug. 30 - Sept. 3, 2005)
- *Participant* in the ECOOP 2005 Workshops RAM-SE'05: Reflection, AOP and Meta-Data for Software Evolution and [6th International Workshop on Object-Oriented Reengineering (WOOR)](http://smallwiki.unibe.ch/WOOR) (European Conference on Object-Oriented Programming &#8212; Glasgow, Scotland, UK, Jul. 25-29, 2005)
- *PC Member* of [IDM 2005](http://idm.imag.fr/idm05/) (Ingénierie Dirigée par les Modèles &#8212; Paris, France, Jun 30 - Jul 1, 2005)
- *Participant* in [Dagstuhl-Seminar 05251](http://www.dagstuhl.de/05251/) (Types for Tools: Applications of Type Theoretic Techniques &#8212; Schloss Dagstuhl, June 19-24, 2005)
- *Organizing* [ChaSE](http://w3.umh.ac.be/evol/meetings/evol2005.html) (ERCIM-ESF Workshop on Challenges in Software Evolution &#8212; Bern, April 12-13, 2005)
- *Organizing* the [CHOOSE Forum 2005](http://www.choose.s-i.ch/Events/forum2005.html) (Tools for Managing Software Complexity &#8212; Bern, April 11, 2005)
-  *PC Member* and* Invited Speaker *of SC 2005 (Software Composition &#8212; Edinburgh, Scotland, April 9, 2005; co-located with [ETAPS 2005](http://www.etaps05.inf.ed.ac.uk/))
-  *Hosting *[LMO 2005](http://lmo2005.unibe.ch) (Langages et Modèles à Objets &#8212; University of Bern, March 9-11, 2005)
-  *Hosting *[LOTS 2005 ](http://www.lots.ch/) (Let's Open the Source &#8212; University of Bern, Feb 17-19, 2005)
- *Hosting *the [ECOOP 2005 PC meeting](http://2005.ecoop.org/) (University of Bern, Feb 10-11, 2005)

## 2004

- *Workshop Organiser* at [OOPSLA 2004](http://www.oopsla.org/) (&quot;Revival of Dynamic Languages&quot; workshop&#8212; Vancouver, Canada, October, 2004)
- *Tutorial speaker* at [OOPSLA 2004](http://www.oopsla.org/) (&quot;[Object-Oriented Reengineering Patterns](http://www.oopsla.org/2004/ShowEvent.do?id=156)&quot; tutorial &#8212; Vancouver, Canada, October, 2004)
- *Invited speake*r at [UML 2004](http://www.umlconference.org/) (Oct. 11-15, 2004 &#8212; Lisbon, Portugal)
- *PC Member* of [IWPSE 2004](http://iwpse04.wakayama-u.ac.jp/) (International Workshop on Principles of Software Evolution &#151; Kyoto, Japan, Sept. 6-7, 2004)
- *PC Member* of the Euromicro CBSE Track (30th Euromicro &#8212; Rennes, France, Sept 3, 2004)
- *PC Member* of [ECOOP 2004](http://www.ifi.uio.no/ecoop2004/) (European Conference for Object-Oriented Programming &#151; Oslo, Norway, June 14-19, 2004)
- *Keynote speaker* at CBSE7 (International Symposium on Component-Based Software Engineering &#8212; Edinburgh, Scotland, May 24-25, 2004)*Speaker* at [SI-SE 2004](http://www.ifi.unizh.ch/si-se/sise2004/) (Components &#8212; The Future of Software Engineering? &#8212; University of Zurich, March 18-19, 2004)
- *Co-organizing* LOTS event (Let's Open the Source &#8212; University of Bern, Feb 18, 2004)
- *Tutorial speaker* at OOP 2004 (&quot;Object-Oriented Reengineering Patterns&quot; tutorial &#8212; Munich, Germany, Jan 23, 2004)

## 2003

- *Presiding* CHOOSE Forum tutorial by Angelika Langer: *New Features in the Java 2 Standard Edition 1.5* &#8212; Kursaal Bern, Nov 3, 2003
- *Hosting* *LOTS (Let's Open the Source) Kickoff event* &#8212; U Bern, Oct 24, 2003 
- Co-hosting SSUG/CHOOSE Tutorial by Jospeh Pelrine: *[SCRUM: A Methodology to Keep the Team Going](http://www.iam.unibe.ch/~ssug/Events/20031014.html)* &#8212; U Bern, Oct 14, 2003
- *Hosting* CHOOSE SIG Beer by Franz Achermann: *Naked Objects *&#8212; U Bern, Oct 8, 2003
- *PC Member* of [ECOOP 2003](http://www.ecoop.tu-darmstadt.de/) (European Conference for Object-Oriented Programming &#151; Darmstadt, Germany, July 21-25, 2003)
- *Member of the Workshop Committee* for ICSE 2003 (International Conference on Software Engineering &#151; Portland, Orgeon, May 3-10, 2003)
- *PC Member* of FOAL 2003 (Foundations of Aspect-Oriented Languages &#8212; workshop at AOSD 2003)
- *PC Member* of AOSD 03 (Aspect-Oriented Software Development &#8212; Enschede, The Netherlands, April 22-26, 2003)
- *PC Member* of ESOP 03 (European Symposium On Programming &#151; Warsaw, Poland, April 7-11 2003) 
- *Speaker* at [SI-SE 2003](http://www.ifi.unizh.ch/sise/) ([Software Sanierung](http://www.hsr.ch/weiterbildung/sise2003/) &#8212; Zürich, March 13-14, 2003) 
- *Tutorial speaker* at [ OMG Information Days 2003 ](http://www.ltt.de/omg-days.2003/zurich.shtml) (Zürich, Feb 26, 2003) 

## 2002

- CHOOSE Tutorial &quot;Object-Oriented Reengineering Patterns&quot; &#8212; University of Bern, Nov. 28, 2002
- *Invited Speaker* at [FMCO 2002](http://fmco.liacs.nl/fmco02.html) (First International Symposium on Formal Methods for Components and Objects &#8212; Leiden, The Netherlands, Nov. 5-8, 2002)
- *PC Member* of [OOPSLA 2002](http://oopsla.acm.org/) (Conference on Object-Oriented Programming, Systems, Languages, and Applications &#151; Seattle, Washington, Nov 4-8 2002)
- *PC Member *of Radical Innovations of Software and Systems Engineering in the Future &#151;Venice, Italy, Oct 7-11 2002
- *Invited Speaker*, [Industrielle Software Produktion 2002](http://www.informatik.uni-stuttgart.de/isp/isp_home.html) &#151; Stuttgart, Sept. 19-20, 2002
- *PC Member* of [EDOC 2002](http://edoc.dstc.edu.au/) (The 6th International Conference on Enterprise Distributed Object Computing &#151; Lausanne, Switzerland Sept 17-20, 2002)
- *PC Member *of [CD 2002](http://swt.cs.tu-berlin.de/cd02/) (First International Working Conference on Component Deployment &#151; Berlin, Germany, June 20-21, 2002; co-located with [PLDI](http://sunshine.cs.uni-dortmund.de/~knoop/PLDI2002/pldi2002_main.html), June 17-19) 
- *PC Member* of [CAiSE 2002](http://www.cs.toronto.edu/caise02/) (The Fourteenth International Conference on Advanced Information Systems Engineering &#151; Toronto, Canada, May 27-31, 2002) 
- *PC Member* of [FOAL](http://www.cs.wustl.edu/~cytron/FOAL/) (Foundations of Aspect Oriented Languages &#151; co-located with [AOSD](http://trese.cs.utwente.nl/aosd2002.htm), Twente, the Netherlands, April 23-26, 2002)
- *PC Member* of Coordination 2002 (Fifth International Conference on Coordination Models and Languages &#151; York, UK, April 8-1, 2002 )

## 2001

- *PC Member* of [OOPSLA 2001](http://oopsla.acm.org/) (Conference on Object-Oriented Programming, Systems, Languages, and Applications &#151; Tampa, Florida, Oct 14-18, 2001) 
- *PC Member* of [TOOLSEE 2001](http://toolsee.vub.ac.be/) (TOOLS Eastern Europe 2001 &#151; Varna, Bulgaria,Sept 25-28, 2001)
- *Keynote speaker* at [GCSE 2001](http://gcse2001.cs.rug.nl/) (Third International Conference on Generative and Component-Based Software Engineering &#151; Erfurt, Germany Sept 10-13, 2001)
- *PC Member* of [CoopIS 2001](http://www.science.unitn.it/coopis/) (Sixth International Conference on CooperativeÃ Information Systems &#151; Trento, Italy Sept 5-7, 2001)
- *PC Member* of [EDOC 2001](http://edoc.doc.ic.ac.uk/) (The 5th International Conference on Enterprise Distributed Object Computing &#151; Seattle, Washington, USA, Sept 4-7, 2001)
- *PC Member* of [CAiSE 2001](http://www.caise01.ch/) (The 13th Conference on Advanced Information Systems Engineering &#151; Interlaken, Switzerland, June 4-8, 2001)
- *"Member of the Tutorials Subcommittee"* [ICSE 2001](http://www.csr.uvic.ca/icse2001/) (The 23d International Conference on Software Engineering &#151; Toronto, Canada, May 12-19, 2001)
- *Invited speaker* at the Component Based Software Day (CWI, Amsterdam &#151; April 27, 2001)
- *PC member* of [WPDRTS 2001](http://csce.uark.edu/~aapon/wpdrts2001/) (Ninth International Workshop on Parallel and Distributed Real-Time Systems &#151; San Francisco, April 23-24, 2001)

## 2000

- *Sabbatical *at Tokyo Institute of Technology (June 2000 - March 2001)
- *Co-organizer* [ECOOP 2000 workshop: Pervasive Component Systems](http://ecoop2000.unice.fr/Program/Technical/Workshops/w22.html) &#8212; Sophia Antipolis, June 12, 2000
-  *PC member* of ICSE 2000 (The 22d International Conference on Software Engineering &#8212; Limerick, Ireland, June 4-11, 2000)
- *Co-organizer* [Agent Technology Spring School](http://www.iam.unibe.ch/~scg/AgentTechnology/) &#8212; Lenk, Switzerland, March 6-10, 2000
- *Speaker* [Software Architectures and Component Technology](http://qose.cs.utwente.nl/sact2000/) &#8212; Twente, The Netherlands, January 20-21, 2000

## 1999

-  [ *Tutorial presenter*](http://www.acm.org/sigplan/oopsla/oopsla99/2_ap/tutorials/tut4.html) and [ *Doctoral Symposium Mentor*](http://www.acm.org/sigplan/oopsla/oopsla99/2_ap/2g_docsymp.html) at [OOPSLA 99](http://www.acm.org/sigplan/oopsla/index.html) (Conference on Object-Oriented Programming, Systems, Languages, and Applications &#8212; Denver, CO, Nov. 1-5, 1999) 
- *Invited speaker at* [EESI System Architecture Colloquia](http://www.eesi.tue.nl/english/coll-architecture.html) &#8212; TUE Eindhoven, NL, Oct. 6, 1999
-  *Programme Chair* of ESEC 99/FSE-7 (joint European Software Engineering Conference and ACM SIGSOFT Symposium on the Foundations of Software Engineering &#8212; Toulouse, France, Sept. 6-10, 1999)
-  *PC member* of [ECOOP 99](http://www.di.fc.ul.pt/ecoop99/) (European Conference on Object-Oriented Programming &#8212; Lisbon, Portugal, June 14-18, 1999.)
-  *PC member* of Coordination 99 &#8212; Amsterdam, NL, 28-30 April 1999
-  *PC member* of ESOP 99 (European Symposium On Programming &#8212; Amsterdam, NL, 22-26 March 1999)
- *Hosting* CHOOSE Forum on Software Architecture '99 &#8212; U. Bern, March 11th, 1999. 
- *Invited speaker at* FMOODS 99 &#8212; Florence, Italy, Feb 15-18, 1999 

## 1998

- *Invited speaker at* [Architectural Approaches to Software Engineering](http://mcs.open.ac.uk/SoftEngSem/SoftEngSem.html) (seminar) &#8212; Open University, UK, Dec 8-9, 1998
