---
title: "Making Systems Explainable"
collection: publications
permalink: /publication/2022-10-03-Nier22a-MakingSystemsExplainable
excerpt: 'In this keynote presentation, we will show how software systems can be made explainable with the help of three interacting technologies.'
date: 2022-10-03
venue: 'VISSOFT'
paperurl: 'https://www.oscar.nierstrasz.org/files/publications/Nier22a-ExplainableSystems.pdf'
citation: 'Oscar Nierstrasz and Tudor Gîrba, Making Systems Explainable, VISSOFT 22: Proceedings of the 10th IEEE Working Conference on Software Visualization, IEEE, 2022.'
---

[PDF download](https://www.oscar.nierstrasz.org/files/publications/Nier22a-ExplainableSystems.pdf)
| [SCG bib citation](https://scg.unibe.ch/scgbib/?query=Nier22a&filter=Year)
| [Talk](/talks/2022-10-03-VISSOFT-MakingSystemsExplainable)

# Abstract
What makes software systems explainable? As we develop
and maintain software, we have questions to ask about
the code, but piecing together the answers remains hard.
The main interface the classical IDE offers is a text
editor for the source code. Code, documentation, and the
running system are disconnected. In this keynote
presentation, we will show how software systems can be
made explainable with the help of three interacting
technologies: (i) live notebooks that can be used to
create narratives that link documentation, source code,
and running applications, (ii) example methods that not
only perform tests, but produce live examples that can
be used within narratives, to explain use cases,
scenarios and features, and (iii) a moldable inspector
that can be easily extended with live custom views to
answer domain-specific questions about software systems.
With the help of running examples we will show in the
keynotes presentation how these technologies work
together to provide a radically different kind of
development experience.
