---
title: Object-Oriented Reengineering Patterns
permalink: /oorp/
author_profile: false
sidebar:
  nav: "oorp"
---

![old and new front covers](/files/oorp/oorp-2x.jpg)

# About this book

*Object-Oriented Reengineering Patterns* collects and distills successful techniques in planning a reengineering project, reverse-engineering, problem detection, migration strategies and software redesign.

When the original edition published by Morgan Kaufmann in 2003 went out of print, the copyright [reverted to the authors](/files/oorp/oorp-copyright-reversion.jpg). We consequently made this volume available under a [Creative Commons Attribution-ShareAlike 3.0 license](http://creativecommons.org/licenses/by-sa/3.0/).

You can [download the book as a free PDF](/files/oorp/OORP-2013-11-27.pdf),
or you can order a paperback copy from [Lulu](https://www.lulu.com/shop/oscar-nierstrasz-and-serge-demeyer-and-st%C3%A9phane-ducasse/object-oriented-reengineering-patterns/ebook/product-17gpzm5e.html?q=&page=1&pageSize=4). 
The original hardcover is also available again from [Amazon](https://www.amazon.com/Object-Oriented-Reengineering-Patterns-Engineering-Programming/dp/1558606394/ref=sr_1_1).

# Contents

*The documentation is missing or obsolete, and the original developers have departed. Your team has limited understanding of the system, and unit tests are missing for many, if not all, of the components. When you fix a bug in one place, another bug pops up somewhere else in the system. Long rebuild times make any change difficult. All of these are signs of software that is close to the breaking point.*

Many systems can be upgraded or simply thrown away if they no longer serve their purpose. Legacy software, however, is crucial for operations and needs to be continually available and upgraded. How can you reduce the complexity of a legacy system sufficiently so that it can continue to be used and adapted at acceptable cost?

Based on the authors' industrial experiences, this book is a guide on how to reverse engineer legacy systems to understand their problems, and then reengineer those systems to meet new demands. Patterns are used to clarify and explain the process of understanding large code bases, hence transforming them to meet new requirements. The key insight is that the right design and organization of your system is not something that can be evident from the initial requirements alone, but rather as a consequence of understanding how these requirements evolve.

> This book speaks with experience. It gives you the building blocks for a plan to tackle a difficult code base and the context for techniques like refactoring. It is a sad fact that there are too few of these kinds of books out there, when reengineering is such a common event. But I'm at least glad to see that while there aren't many books in this vein, this book is an example of how good they are.
>
> — From the foreword by Martin Fowler

# About the Authors

[Serge Demeyer](http://www.win.ua.ac.be/~sdemey/) is a professor in the Department of Mathematics and Computer Science at the University of Antwerp in Belgium.
[Stéphane Ducasse](http://stephane.ducasse.free.fr/) is a research director at INRIA Lille in France.
[Oscar Nierstrasz](https://www.oscar.nierstrasz.org/) is a professor emeritus of computer science at the University of Bern, and now works for [feenk.com](https://feenk.com/about/).

---
*Published by Square Bracket Associates*
