Object subclass: #VRPaper
	instanceVariableNames: 'data'
	classVariableNames: ''
	package: 'VisualisationReview-Model'!
!VRPaper commentStamp: '<historical>' prior: 0!
I represent a paper (publication) in a Visualization Review dataset.!


!VRPaper methodsFor: 'accessing' stamp: '1/28/2026 12:59'!
data
	^ data! !

!VRPaper methodsFor: 'accessing' stamp: '1/28/2026 12:59'!
type
	^ self data at: 'Type'! !

!VRPaper methodsFor: 'accessing' stamp: '1/28/2026 12:59'!
id
	^ (self data at: 'ID') asNumber! !

!VRPaper methodsFor: 'accessing' stamp: '1/28/2026 12:59'!
title
	^ self data at: 'Title'! !


!VRPaper methodsFor: 'initialization' stamp: '1/28/2026 12:59'!
data: aDictionary
	data := aDictionary! !


!VRPaper methodsFor: 'testing' stamp: '1/28/2026 12:59'!
isDesignStudy
	^ self type = 'Design Study'! !


!VRPaper methodsFor: 'printing' stamp: '1/28/2026 12:59'!
printOn: aStream
	aStream nextPutAll: self title! !


!VRPaper methodsFor: 'views' stamp: '1/28/2026 12:59'!
gtJsonFor: aView
	<gtView>
	^ aView forward
		title: 'JSON';
		object: [ self data ];
		view: #gtItemsFor:! !

!VRPaper methodsFor: 'views' stamp: '1/28/2026 13:08'!
gtSummaryFor: aView
	<gtView>
	^ aView columnedList
		title: 'Summary';
		priority: 10;
		items: [ {{'ID'.
					self id}.
				{'Title'.
					self title}.
				{'Type'.
					self type}.
				{'# Authors'.
					self data at: '# Authors'}.
				{'# Pages'.
					self data at: '# Pages'}.
				{'Is selected'.
					self isDesignStudy}} ];
		column: 'Key'
			text: #first
			width: 100;
		column: 'Value' text: #second;
		actionUpdateButton! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VRPaper class
	instanceVariableNames: ''!
!VRPaper class commentStamp: '<historical>' prior: 0!
I represent a paper (publication) in a Visualization Review dataset.!


!VRPaper class methodsFor: 'instance creation' stamp: '1/28/2026 12:59'!
for: aDictionary
	^ self new
		data: aDictionary;
		yourself! !
Object subclass: #VRDatasetExamples
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'VisualisationReview-Examples'!

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 12:59'!
allPapersJSON
	<gtExample>
	| json |
	json := (CSV2JSON
			for: (self datasetFolder / 'dataset-review-vissoft-all.csv') contents)
			jsonObject.
	self assert: json size equals: 346.
	^ json! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 12:59'!
datasetFolder
	<gtExample>
	| folder |
	folder := FileLocator gtResource / 'feenkcom' / 'gtoolkit-demos'
			/ 'data' / 'visualisation-review'.
	self assert: folder exists.
	self assert: (folder allChildrenMatching: '*.csv') size equals: 2.
	^ folder! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 12:59'!
selectedPapersJSON
	<gtExample>
	| json |
	json := (CSV2JSON
			for: (self datasetFolder / 'dataset-review-vissoft-selected.csv') contents)
			jsonObject.
	self assert: json size equals: 65.
	^ json! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 12:59'!
allPapers
	<gtExample>
	| papers |
	papers := self allPapersJSON collect: [ :data | VRPaper for: data ].
	self assert: papers size equals: 346.
	^ papers! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 12:59'!
designStudies
	<gtExample>
	| papers |
	papers := self allPapers select: #isDesignStudy.
	self assert: papers size equals: 65.
	^ papers! !


!VRDatasetExamples methodsFor: 'accessing' stamp: '1/28/2026 12:59'!
paper128
	<gtExample>
	| paper |
	paper := self allPapers detect: [ :p | p id = 128 ].
	self assert: paper id equals: 128.
	self assert: paper isDesignStudy.
	^ paper! !
