Object subclass: #VRPaper
	instanceVariableNames: 'data'
	classVariableNames: ''
	package: 'VisualisationReview-Model'!
!VRPaper commentStamp: '<historical>' prior: 0!
I represent a paper (publication) in a Visualization Review dataset.!


!VRPaper methodsFor: 'accessing' stamp: '1/27/2026 10:05'!
data
	^ data! !


!VRPaper methodsFor: 'initialization' stamp: '1/27/2026 10:05'!
data: aDictionary
	data := aDictionary! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VRPaper class
	instanceVariableNames: ''!
!VRPaper class commentStamp: '<historical>' prior: 0!
I represent a paper (publication) in a Visualization Review dataset.!


!VRPaper class methodsFor: 'instance creation' stamp: '1/27/2026 10:05'!
for: aDictionary
	^ self new
		data: aDictionary;
		yourself! !
Object subclass: #VRDatasetExamples
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'VisualisationReview-Examples'!

!VRDatasetExamples methodsFor: 'examples' stamp: '1/27/2026 10:04'!
allPapersJSON
	<gtExample>
	| json |
	json := (CSV2JSON
			for: (self datasetFolder / 'dataset-review-vissoft-all.csv') contents)
			jsonObject.
	self assert: json size equals: 346.
	^ json! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/27/2026 10:04'!
datasetFolder
	<gtExample>
	| folder |
	folder := FileLocator gtResource / 'feenkcom' / 'gtoolkit-demos'
			/ 'data' / 'visualisation-review'.
	self assert: folder exists.
	self assert: (folder allChildrenMatching: '*.csv') size equals: 2.
	^ folder! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/27/2026 10:04'!
selectedPapersJSON
	<gtExample>
	| json |
	json := (CSV2JSON
			for: (self datasetFolder / 'dataset-review-vissoft-selected.csv') contents)
			jsonObject.
	self assert: json size equals: 65.
	^ json! !
