Object subclass: #VRDatasetExamples
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'VisualisationReview-Examples'!

!VRDatasetExamples methodsFor: 'examples' stamp: '1/27/2026 17:02'!
allPapersJSON
	<gtExample>
	| json |
	json := (CSV2JSON
			for: (self datasetFolder / 'dataset-review-vissoft-all.csv') contents)
			jsonObject.
	self assert: json size equals: 346.
	^ json! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/27/2026 17:02'!
datasetFolder
	<gtExample>
	| folder |
	folder := FileLocator gtResource / 'feenkcom' / 'gtoolkit-demos'
			/ 'data' / 'visualisation-review'.
	self assert: folder exists.
	self assert: (folder allChildrenMatching: '*.csv') size equals: 2.
	^ folder! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/27/2026 17:02'!
selectedPapersJSON
	<gtExample>
	| json |
	json := (CSV2JSON
			for: (self datasetFolder / 'dataset-review-vissoft-selected.csv') contents)
			jsonObject.
	self assert: json size equals: 65.
	^ json! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/27/2026 17:02'!
allPapers
	<gtExample>
	| papers |
	papers := self allPapersJSON collect: [ :data | VRPaper for: data ].
	self assert: papers size equals: 346.
	^ papers! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/27/2026 17:02'!
designStudies
	<gtExample>
	| papers |
	papers := self allPapers select: #isDesignStudy.
	self assert: papers size equals: 65.
	^ papers! !


!VRDatasetExamples methodsFor: 'accessing' stamp: '1/27/2026 17:02'!
paper128
	<gtExample>
	| paper |
	paper := self allPapers detect: [ :p | p id = 128 ].
	self assert: paper id equals: 128.
	self assert: paper isDesignStudy.
	^ paper! !
Object subclass: #VRPaper
	instanceVariableNames: 'data'
	classVariableNames: ''
	package: 'VisualisationReview-Model'!
!VRPaper commentStamp: '<historical>' prior: 0!
I represent a paper (publication) in a Visualization Review dataset.!


!VRPaper methodsFor: 'accessing' stamp: '1/27/2026 17:02'!
data
	^ data! !

!VRPaper methodsFor: 'accessing' stamp: '1/27/2026 17:02'!
type
	^ self data at: 'Type'! !

!VRPaper methodsFor: 'accessing' stamp: '1/27/2026 17:02'!
id
	^ (self data at: 'ID') asNumber! !

!VRPaper methodsFor: 'accessing' stamp: '1/27/2026 17:02'!
title
	^ self data at: 'Title'! !


!VRPaper methodsFor: 'initialization' stamp: '1/27/2026 17:02'!
data: aDictionary
	data := aDictionary! !


!VRPaper methodsFor: 'testing' stamp: '1/27/2026 17:02'!
isDesignStudy
	^ self type = 'Design Study'! !


!VRPaper methodsFor: 'printing' stamp: '1/27/2026 17:02'!
printOn: aStream
	aStream nextPutAll: self title! !


!VRPaper methodsFor: 'views' stamp: '1/27/2026 17:02'!
gtJsonFor: aView
	<gtView>
	^ aView forward
		title: 'JSON';
		object: [ self data ];
		view: #gtItemsFor:! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VRPaper class
	instanceVariableNames: ''!
!VRPaper class commentStamp: '<historical>' prior: 0!
I represent a paper (publication) in a Visualization Review dataset.!


!VRPaper class methodsFor: 'instance creation' stamp: '1/27/2026 17:02'!
for: aDictionary
	^ self new
		data: aDictionary;
		yourself! !
