Object subclass: #VRDatasetExamples
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'VisualisationReview-Examples'!

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 13:52'!
allPapersJSON
	<gtExample>
	| json |
	json := (CSV2JSON
			for: (self datasetFolder / 'dataset-review-vissoft-all.csv') contents)
			jsonObject.
	self assert: json size equals: 346.
	^ json! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 13:52'!
datasetFolder
	<gtExample>
	| folder |
	folder := FileLocator gtResource / 'feenkcom' / 'gtoolkit-demos'
			/ 'data' / 'visualisation-review'.
	self assert: folder exists.
	self assert: (folder allChildrenMatching: '*.csv') size equals: 2.
	^ folder! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 13:52'!
selectedPapersJSON
	<gtExample>
	| json |
	json := (CSV2JSON
			for: (self datasetFolder / 'dataset-review-vissoft-selected.csv') contents)
			jsonObject.
	self assert: json size equals: 65.
	^ json! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 13:52'!
allPapers
	<gtExample>
	| papers |
	papers := self allPapersJSON collect: [ :data | VRPaper for: data ].
	self assert: papers size equals: 346.
	^ papers! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 13:52'!
designStudies
	<gtExample>
	| papers |
	papers := self allPapers select: #isDesignStudy.
	self assert: papers size equals: 65.
	^ papers! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/28/2026 13:52'!
allPapersWrapped
	<gtExample>
	| papers |
	papers := VRPaperGroup withAll: self allPapers.
	self assert: papers size equals: 346.
	^ papers! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/30/2026 09:36'!
vrDataset
	<gtExample>
	^ VRDataset
		forAllCSV: self datasetFolder / 'dataset-review-vissoft-all.csv'
		andSelectedCSV: self datasetFolder / 'dataset-review-vissoft-selected.csv'! !

!VRDatasetExamples methodsFor: 'examples' stamp: '1/30/2026 12:25'!
authorLanza
	<gtExample>
	| dataset author |
	dataset := self vrDataset.
	author := dataset authorNamed: 'Lanza, M.'.
	self assert: author name equals: 'Lanza, M.'.
	self assert: author papers size equals: 18.
	^ author! !


!VRDatasetExamples methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
paper128
	<gtExample>
	| paper |
	paper := self vrDataset paperWithId: 128.
	self assert: paper id equals: 128.
	self assert: paper isDesignStudy.
	^ paper! !
Object subclass: #VRDataset
	instanceVariableNames: 'allJSON selectedJSON paperDict authorDict venueDict designStudyDict'
	classVariableNames: ''
	package: 'VisualisationReview-Model'!

!VRDataset methodsFor: 'initialization' stamp: '1/30/2026 09:36'!
allJSON: aDictionary selectedJSON: anotherDictionary
	self allJSON: aDictionary.
	self selectedJSON: anotherDictionary! !

!VRDataset methodsFor: 'initialization' stamp: '1/30/2026 10:36'!
initializeAuthorDict
	| dict |
	dict := Dictionary new.
	self allPapers
		do: [ :p | 
			p authorNames
				do: [ :n | (dict at: n ifAbsentPut: [ VRAuthor named: n in: self ]) addPaper: p ] ].
	^ dict! !

!VRDataset methodsFor: 'initialization' stamp: '1/30/2026 17:59'!
initializeVenueDict
	"NB: Venues have both names and years, so the dictionary must be index on both."

	| dict |
	dict := Dictionary new.
	self allPapers
		do: [ :p | 
			(dict
				at: {p venueName.
						p year}
				ifAbsentPut: [ VRVenue
						named: p venueName
						year: p year
						in: self ]) addPaper: p ].
	^ dict! !


!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
selectedJSON
	^ selectedJSON! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
allJSON
	^ allJSON! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
selectedJSON: aDictionary
	selectedJSON := aDictionary! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
allJSON: aDictionary
	allJSON := aDictionary! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
allPapers
	^ VRPaperGroup withAll: self paperDict values! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
selectedPapers
	^ self allPapers select: #isDesignStudy! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
paperDict
	^ paperDict
		ifNil: [ paperDict := ((self allJSON collect: [ :d | VRPaper for: d in: self ])
					collect: [ :p | p id -> p ]) asDictionary ]! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
authorDict
	^ authorDict ifNil: [ authorDict := self initializeAuthorDict ]! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 13:29'!
authors
	^ VRAuthorGroup withAll: (self authorDict values sortedAs: #name)! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 17:59'!
venueDict
	^ venueDict ifNil: [ venueDict := self initializeVenueDict ]! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 17:59'!
venues
	^ VRVenueGroup
		withAll: (self venueDict values
				sort: [ :a :b | a year <= b year and: [ a name <= b name ] ])! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 20:08'!
initializeDesignStudyDict
	| dict |
	dict := Dictionary new.
	self selectedJSON
		do: [ :d | dict at: (d at: 'ID') asNumber ifAbsentPut: (VRDesignStudy for: d in: self) ].
	^ dict! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 20:08'!
designStudyDict
	^ designStudyDict ifNil: [ designStudyDict := self initializeDesignStudyDict ]! !

!VRDataset methodsFor: 'accessing' stamp: '1/30/2026 20:08'!
designStudies
	^ VRDesignStudyGroup withAll: (self designStudyDict values sortedAs: #title)! !


!VRDataset methodsFor: 'views' stamp: '1/30/2026 09:36'!
gtAllPapersFor: aView
	<gtView>
	^ aView forward
		title: 'All papers';
		priority: 10;
		object: [ self allPapers ];
		view: #gtItemsFor:! !

!VRDataset methodsFor: 'views' stamp: '1/30/2026 09:36'!
gtSelectedPapersFor: aView
	<gtView>
	^ aView forward
		title: 'Selected papers';
		priority: 20;
		object: [ self selectedPapers ];
		view: #gtItemsFor:! !

!VRDataset methodsFor: 'views' stamp: '1/30/2026 13:30'!
gtAuthorsFor: aView
	<gtView>
	^ aView forward
		title: 'Authors';
		priority: 30;
		object: [ self authors ];
		view: #gtAuthorsFor:! !

!VRDataset methodsFor: 'views' stamp: '1/30/2026 20:08'!
gtVenuesFor: aView
	<gtView>
	^ aView forward
		title: 'Venues';
		priority: 40;
		object: [ self venues ];
		view: #gtVenuesFor:! !

!VRDataset methodsFor: 'views' stamp: '1/30/2026 20:08'!
gtDesignStudiesFor: aView
	<gtView>
	^ aView forward
		title: 'Design studies';
		priority: 50;
		object: [ self designStudies ];
		view: #gtDesignStudiesFor:! !


!VRDataset methodsFor: 'querying' stamp: '1/30/2026 09:36'!
paperWithId: id
	^ self paperDict at: id! !

!VRDataset methodsFor: 'querying' stamp: '1/30/2026 12:25'!
authorNamed: aName
	^ self authorDict at: aName! !

!VRDataset methodsFor: 'querying' stamp: '1/30/2026 17:59'!
venueNamed: aString year: anotherString
	^ self venueDict
		at: {aString.
				anotherString}! !


!VRDataset methodsFor: 'search' stamp: '1/30/2026 15:26'!
gtSpotterForPaperTitles: aSearch
	<gtSearch>
	^ aSearch list
		title: 'Paper titles';
		priority: 10;
		items: [ self allPapers ];
		itemsLimit: Float infinity;
		itemName: #title;
		sendCategory: [ :aCategory :aStep :thisSearch |
			VRPaperGroup withAll: aCategory items contents ];
		filterBySubstring! !

!VRDataset methodsFor: 'search' stamp: '1/30/2026 15:26'!
gtSpotterForPaperTypes: aSearch
	<gtSearch>
	^ aSearch list
		title: 'Paper titles';
		priority: 20;
		items: [ self allPapers ];
		itemsLimit: Float infinity;
		itemName: #type;
		sendCategory: [ :aCategory :aStep :thisSearch |
			VRPaperGroup withAll: aCategory items contents ];
		filterBySubstring! !

!VRDataset methodsFor: 'search' stamp: '1/30/2026 15:26'!
gtSpotterForAuthorNames: aSearch
	<gtSearch>
	^ aSearch list
		title: 'Author name';
		priority: 30;
		items: [ self authors ];
		itemsLimit: Float infinity;
		itemName: #name;
		sendCategory: [ :aCategory :aStep :thisSearch |
			VRAuthorGroup withAll: aCategory items contents ];
		filterBySubstring! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VRDataset class
	instanceVariableNames: ''!

!VRDataset class methodsFor: 'instance creation' stamp: '1/30/2026 09:36'!
forAllCSV: aCSVfile andSelectedCSV: anotherCSVFile
	^ self new
		allJSON: (CSV2JSON for: aCSVfile contents) jsonObject
		selectedJSON: (CSV2JSON for: anotherCSVFile contents) jsonObject! !


Object subclass: #VRDomainEntityGroup
	uses: TGtGroupWithItems
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'VisualisationReview-Model'!









"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VRDomainEntityGroup class
	uses: TGtGroupWithItems classTrait
	instanceVariableNames: ''!












VRDomainEntityGroup subclass: #VRVenueGroup
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'VisualisationReview-Model'!

!VRVenueGroup methodsFor: 'as yet unclassified' stamp: '1/30/2026 17:59'!
gtVenuesFor: aView
	<gtView>
	^ aView columnedList
		title: 'Venues';
		items: [ self items ];
		column: 'Index'
			text: [ :eachItem :eachIndex | eachIndex asRopedText foreground: Color gray ]
			width: 45;
		column: 'Name' text: [ :each | each name ];
		column: 'Year' text: [ :each | each year ];
		column: '# Papers' text: [ :each | each papers size ];
		actionUpdateButton! !


VRDomainEntityGroup subclass: #VRPaperGroup
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'VisualisationReview-Model'!

!VRPaperGroup methodsFor: 'views' stamp: '1/28/2026 13:53'!
gtItemsFor: aView
	<gtView>
	^ aView columnedList
		title: 'Papers';
		items: [ self items ];
		column: 'Index'
			text: [ :eachItem :eachIndex | eachIndex asRopedText foreground: Color gray ]
			width: 45;
		column: 'Title' text: [ :each | each title ];
		column: 'Type' text: [ :each | each type ];
		actionUpdateButton! !


VRDomainEntityGroup subclass: #VRDesignStudyGroup
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'VisualisationReview-Model'!

!VRDesignStudyGroup methodsFor: 'views' stamp: '1/30/2026 20:08'!
gtDesignStudiesFor: aView
	<gtView>
	^ aView columnedList
		title: 'Design studies';
		items: [ self items ];
		column: 'Index'
			text: [ :eachItem :eachIndex | eachIndex asRopedText foreground: Color gray ]
			width: 45;
		column: 'Title' text: [ :each | each title ];
		actionUpdateButton! !


VRDomainEntityGroup subclass: #VRAuthorGroup
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'VisualisationReview-Model'!

!VRAuthorGroup methodsFor: 'views' stamp: '1/30/2026 13:41'!
gtAuthorsFor: aView
	<gtView>
	^ aView columnedList
		title: 'Authors';
		priority: 10;
		items: [ self items ];
		column: 'Index'
			text: [ :eachItem :eachIndex | eachIndex asRopedText foreground: Color gray ]
			width: 45;
		column: 'Author'
			text: [ :each | each gtDisplayString ]
			width: 150;
		column: '# Papers'
			text: [ :each | each papers size ]
			width: 80;
		column: '# Co-authors'
			text: [ :each | each coauthors size ]
			width: 80;
		actionUpdateButton! !


Object subclass: #VRDomainEntity
	instanceVariableNames: 'dataset'
	classVariableNames: ''
	package: 'VisualisationReview-Model'!

!VRDomainEntity methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
dataset
	^ dataset! !

!VRDomainEntity methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
dataset: aDataset
	dataset := aDataset! !


!VRDomainEntity methodsFor: 'actions' stamp: '1/30/2026 14:10'!
gtDatasetFor: anAction
	<gtAction>
	^ anAction button
		icon: BrGlamorousVectorIcons up;
		tooltip: 'Spawn dataset';
		action: [ :button | button phlow spawnObject: self dataset ]! !


!VRDomainEntity methodsFor: 'mondrian' stamp: '1/30/2026 16:14'!
mondrianNodeElementHighlighting: aNode
	self subclassResponsibility! !

!VRDomainEntity methodsFor: 'mondrian' stamp: '1/30/2026 16:14'!
mondrianNodeColor
	self subclassResponsibility! !

!VRDomainEntity methodsFor: 'mondrian' stamp: '1/30/2026 16:14'!
mondrianChildren
	self subclassResponsibility! !

!VRDomainEntity methodsFor: 'mondrian' stamp: '1/30/2026 16:14'!
mondrianBorderHighlighting: aNode
	^ BlBorder paint: Color black width: 1! !


VRDomainEntity subclass: #VRVenue
	instanceVariableNames: 'name papers year'
	classVariableNames: ''
	package: 'VisualisationReview-Model'!

!VRVenue methodsFor: 'accessing' stamp: '1/30/2026 17:59'!
name
	^ name! !

!VRVenue methodsFor: 'accessing' stamp: '1/30/2026 17:59'!
name: aString
	name := aString! !

!VRVenue methodsFor: 'accessing' stamp: '1/30/2026 17:59'!
papers
	^ VRPaperGroup withAll: papers! !

!VRVenue methodsFor: 'accessing' stamp: '1/30/2026 17:59'!
year
	^ year! !

!VRVenue methodsFor: 'accessing' stamp: '1/30/2026 17:59'!
year: aString
	year := aString! !

!VRVenue methodsFor: 'accessing' stamp: '1/30/2026 17:59'!
authors
	^ VRAuthorGroup
		withAll: (((self papers flatCollect: #authors) copyWithout: self) copyWithoutDuplicates
				sortedAs: #name)! !


!VRVenue methodsFor: 'initialization' stamp: '1/30/2026 17:59'!
addPaper: aPaper
	papers add: aPaper! !

!VRVenue methodsFor: 'initialization' stamp: '1/30/2026 17:59'!
initialize
	papers := OrderedCollection new! !


!VRVenue methodsFor: 'views' stamp: '1/30/2026 17:59'!
gtSummaryFor: aView
	<gtView>
	^ aView columnedList
		title: 'Summary';
		priority: 10;
		items: [ {{'Name'.
					self name}.
				{'Year'.
					self year}.
				{'# Papers'.
					self papers size}} ];
		column: 'Key'
			text: #first
			width: 100;
		column: 'Value' text: #second;
		actionUpdateButton! !

!VRVenue methodsFor: 'views' stamp: '1/30/2026 17:59'!
gtPapersFor: aView
	<gtView>
	^ aView forward
		title: 'Papers';
		priority: 20;
		object: [ self papers ];
		view: #gtItemsFor:! !

!VRVenue methodsFor: 'views' stamp: '1/30/2026 17:59'!
gtAuthorsFor: aView
	<gtView>
	^ aView forward
		title: 'Authors';
		priority: 30;
		object: [ self authors ];
		view: #gtAuthorsFor:! !


!VRVenue methodsFor: 'printing' stamp: '1/30/2026 17:59'!
printOn: aStream
	aStream
		nextPutAll: self name;
		nextPutAll: ': ';
		nextPutAll: self year! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VRVenue class
	instanceVariableNames: ''!

!VRVenue class methodsFor: 'instance creation' stamp: '1/30/2026 17:59'!
named: aString year: anotherString in: aDataset
	^ self new
		name: aString;
		year: anotherString;
		dataset: aDataset;
		yourself! !


VRDomainEntity subclass: #VRPaper
	instanceVariableNames: 'data'
	classVariableNames: ''
	package: 'VisualisationReview-Model'!
!VRPaper commentStamp: '<historical>' prior: 0!
I represent a paper (publication) in a Visualization Review dataset.!


!VRPaper methodsFor: 'accessing' stamp: '1/28/2026 13:52'!
data
	^ data! !

!VRPaper methodsFor: 'accessing' stamp: '1/28/2026 13:52'!
type
	^ self data at: 'Type'! !

!VRPaper methodsFor: 'accessing' stamp: '1/28/2026 13:52'!
id
	^ (self data at: 'ID') asNumber! !

!VRPaper methodsFor: 'accessing' stamp: '1/28/2026 13:52'!
title
	^ self data at: 'Title'! !

!VRPaper methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
dataset
	^ dataset! !

!VRPaper methodsFor: 'accessing' stamp: '1/30/2026 09:36'!
dataset: aDataset
	dataset := aDataset! !

!VRPaper methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
authorNames
	^ (self authorFields collect: [ :f | self data at: f ] thenSelect: #isNotEmpty)
		collect: [ :n | n trimBoth: [ :c | c == $" ] ]! !

!VRPaper methodsFor: 'accessing' stamp: '1/30/2026 12:25'!
authors
	^ VRAuthorGroup
		withAll: (self authorNames collect: [ :n | self dataset authorNamed: n ])! !

!VRPaper methodsFor: 'accessing' stamp: '1/30/2026 17:59'!
venueName
	^ self data at: 'Venue'! !

!VRPaper methodsFor: 'accessing' stamp: '1/30/2026 17:59'!
year
	^ self data at: 'Year'! !

!VRPaper methodsFor: 'accessing' stamp: '1/30/2026 17:59'!
venue
	^ self dataset venueNamed: self venueName year: self year! !

!VRPaper methodsFor: 'accessing' stamp: '1/30/2026 20:08'!
designStudy
	self isDesignStudy ifFalse: [ ^ nil ].
	^ self dataset designStudyDict at: self id! !


!VRPaper methodsFor: 'initialization' stamp: '1/28/2026 13:52'!
data: aDictionary
	data := aDictionary! !


!VRPaper methodsFor: 'testing' stamp: '1/28/2026 13:52'!
isDesignStudy
	^ self type = 'Design Study'! !


!VRPaper methodsFor: 'printing' stamp: '1/28/2026 13:52'!
printOn: aStream
	aStream nextPutAll: self title! !


!VRPaper methodsFor: 'views' stamp: '1/28/2026 13:52'!
gtJsonFor: aView
	<gtView>
	^ aView forward
		title: 'JSON';
		object: [ self data ];
		view: #gtItemsFor:! !

!VRPaper methodsFor: 'views' stamp: '1/30/2026 20:08'!
gtSummaryFor: aView
	<gtView>
	^ aView columnedList
		title: 'Summary';
		priority: 10;
		items: [ {{'ID'.
					self id}.
				{'Title'.
					self title}.
				{'Type'.
					self type.
					self designStudy}.
				{'# Authors'.
					self data at: '# Authors'}.
				{'# Pages'.
					self data at: '# Pages'}.
				{'Is selected'.
					self isDesignStudy}.
				{'Venue'.
					self venue}} ];
		column: 'Key'
			text: #first
			width: 100;
		column: 'Value' text: #second;
		send: #last;
		actionUpdateButton! !

!VRPaper methodsFor: 'views' stamp: '1/30/2026 12:25'!
gtAuthorsFor: aView
	<gtView>
	^ aView forward
		title: 'Authors';
		priority: 20;
		object: [ self authors ];
		view: #gtAuthorsFor:! !

!VRPaper methodsFor: 'views' stamp: '1/30/2026 14:23'!
gtGoogleScholarFor: anAction
	<gtAction>
	^ anAction button
		icon: BrGlamorousVectorIcons web;
		priority: 10;
		tooltip: 'Look up in Google Scholar';
		action: [ :button | 
			WebBrowser
				openOn: 'https://scholar.google.com/scholar?hl=en&q='
						, (self title copyReplaceAll: String space with: '+') ]! !


!VRPaper methodsFor: 'constant' stamp: '1/30/2026 10:36'!
authorFields
	^ #('First Author' 'Second Author' 'Third Author' 'Fourth Author' 'Fifth Author' 'Sixth Author' 'Seven Author' 'Eighth Author' 'Nineth Author' 'Tenth Author' 'Eleventh Author' 'Twelfth Author')! !


!VRPaper methodsFor: 'mondrian' stamp: '1/30/2026 16:14'!
mondrianNodeElementHighlighting: aNode
	^ BlElement new
		size: 10 @ 10;
		border: (self mondrianBorderHighlighting:aNode);
		background: self mondrianNodeColor;
		aptitude: (BrGlamorousWithExplicitTooltipAptitude text: self printString)! !

!VRPaper methodsFor: 'mondrian' stamp: '1/30/2026 16:14'!
mondrianNodeColor
	^ Color paleBlue! !

!VRPaper methodsFor: 'mondrian' stamp: '1/30/2026 16:21'!
mondrianChildren
	^ {}! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VRPaper class
	instanceVariableNames: ''!
!VRPaper class commentStamp: '<historical>' prior: 0!
I represent a paper (publication) in a Visualization Review dataset.!


!VRPaper class methodsFor: 'instance creation' stamp: '1/28/2026 13:52'!
for: aDictionary
	^ self new
		data: aDictionary;
		yourself! !

!VRPaper class methodsFor: 'instance creation' stamp: '1/30/2026 09:36'!
for: aDictionary in: aDataset
	^ self new
		data: aDictionary;
		dataset: aDataset;
		yourself! !


VRDomainEntity subclass: #VRAuthor
	instanceVariableNames: 'name papers'
	classVariableNames: ''
	package: 'VisualisationReview-Model'!

!VRAuthor methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
name
	^ name! !

!VRAuthor methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
name: aString
	name := aString! !

!VRAuthor methodsFor: 'accessing' stamp: '1/30/2026 12:25'!
papers
	^ VRPaperGroup withAll: papers! !

!VRAuthor methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
addPaper: aPaper
	papers add: aPaper! !

!VRAuthor methodsFor: 'accessing' stamp: '1/30/2026 13:43'!
coauthors
	^ VRAuthorGroup
		withAll: (((self papers flatCollect: #authors) copyWithout: self) copyWithoutDuplicates
				sortedAs: #name)! !

!VRAuthor methodsFor: 'accessing' stamp: '1/30/2026 18:01'!
venues
	^ VRVenueGroup withAll: (self papers collect: #venue) copyWithoutDuplicates! !


!VRAuthor methodsFor: 'initialization' stamp: '1/30/2026 10:36'!
initialize
	papers := OrderedCollection new! !


!VRAuthor methodsFor: 'printing' stamp: '1/30/2026 12:25'!
printOn: aStream
	aStream nextPutAll: self name! !


!VRAuthor methodsFor: 'views' stamp: '1/30/2026 12:25'!
gtPapersFor: aView
	<gtView>
	^ aView forward
		title: 'Papers';
		priority: 10;
		object: [ self papers ];
		view: #gtItemsFor:! !

!VRAuthor methodsFor: 'views' stamp: '1/30/2026 13:41'!
gtSummaryFor: aView
	<gtView>
	^ aView columnedList
		title: 'Summary';
		priority: 10;
		items: [ {{'Name'.
					self name}.
				{'# Papers'.
					self papers size}.
				{'# Co-authors'.
					self coauthors size}} ];
		column: 'Key'
			text: #first
			width: 100;
		column: 'Value' text: #second;
		actionUpdateButton! !

!VRAuthor methodsFor: 'views' stamp: '1/30/2026 13:40'!
gtCoauthorsFor: aView
	<gtView>
	^ aView forward
		title: 'Co-Authors';
		priority: 30;
		object: [ self coauthors ];
		view: #gtAuthorsFor:! !

!VRAuthor methodsFor: 'views' stamp: '1/30/2026 16:14'!
gtCoauthorGraphFor: aView
	<gtView>
	^ aView mondrian
		title: 'Co-author graph';
		priority: 40;
		painting: [ :aMondrian | self coauthorMondrian: aMondrian ];
		actionUpdateButton! !

!VRAuthor methodsFor: 'views' stamp: '1/30/2026 18:01'!
gtVenuesFor: aView
	<gtView>
	^ aView forward
		title: 'Venues';
		priority: 50;
		object: [ self venues ];
		view: #gtVenuesFor:! !


!VRAuthor methodsFor: 'mondrian' stamp: '1/30/2026 16:14'!
mondrianNodeElementHighlighting: aNode
	^ BlTextElement new
		text: self initials asRopedText;
		padding: (BlInsets all: 12);
		border: (self mondrianBorderHighlighting:aNode);
		background: self mondrianNodeColor;
		aptitude: (BrGlamorousWithExplicitTooltipAptitude text: self name);
		geometry: BlCircleGeometry new;
		yourself! !

!VRAuthor methodsFor: 'mondrian' stamp: '1/30/2026 16:14'!
mondrianNodeColor
	^ Color paleRed! !

!VRAuthor methodsFor: 'mondrian' stamp: '1/30/2026 16:14'!
mondrianChildren
	^ self papers! !

!VRAuthor methodsFor: 'mondrian' stamp: '1/30/2026 16:14'!
initials
	^ '' join: (self name substrings collect: #first)! !

!VRAuthor methodsFor: 'mondrian' stamp: '1/30/2026 16:27'!
coauthorMondrian: aMondrian
	| thePapers nodes theAuthors |
	theAuthors := {self} asOrderedCollection , self coauthors.
	thePapers := (theAuthors flatCollect: #papers) copyWithoutDuplicates.
	nodes := theAuthors , thePapers.
	aMondrian nodes
		shape: [ :node | node mondrianNodeElementHighlighting: self ];
		with: nodes.
	aMondrian edges connectToAll: #mondrianChildren.
	aMondrian layout
		custom: (GtGraphForceBasedLayout new
				charge: -2000;
				length: 200).
	^ aMondrian! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VRAuthor class
	instanceVariableNames: ''!

!VRAuthor class methodsFor: 'accessing' stamp: '1/30/2026 10:36'!
named: aName in: aDataset
	^ self new
		name: aName;
		dataset: aDataset;
		yourself! !


VRDomainEntity subclass: #VRDesignStudy
	instanceVariableNames: 'data'
	classVariableNames: ''
	package: 'VisualisationReview-Model'!

!VRDesignStudy methodsFor: 'accessing' stamp: '1/30/2026 20:08'!
data
	^ data! !

!VRDesignStudy methodsFor: 'accessing' stamp: '1/30/2026 20:08'!
data: anObject
	data := anObject! !

!VRDesignStudy methodsFor: 'accessing' stamp: '1/30/2026 20:08'!
title
	^ self data at: 'Title'! !

!VRDesignStudy methodsFor: 'accessing' stamp: '1/30/2026 20:08'!
id
	^ (self data at: 'ID') asNumber! !

!VRDesignStudy methodsFor: 'accessing' stamp: '1/30/2026 20:08'!
paper
	^ self dataset paperWithId: self id! !

!VRDesignStudy methodsFor: 'accessing' stamp: '1/30/2026 20:08'!
venueName
	^ self data at: 'Venue'! !

!VRDesignStudy methodsFor: 'accessing' stamp: '1/30/2026 20:08'!
year
	^ self data at: 'Paper Year'! !

!VRDesignStudy methodsFor: 'accessing' stamp: '1/30/2026 20:08'!
venue
	^ self dataset venueNamed: self venueName year: self year! !

!VRDesignStudy methodsFor: 'accessing' stamp: '1/30/2026 20:08'!
abstract
	^ self data at: 'Abstract'! !


!VRDesignStudy methodsFor: 'printing' stamp: '1/30/2026 20:08'!
printOn: aStream
	aStream nextPutAll: self title! !


!VRDesignStudy methodsFor: 'as yet unclassified' stamp: '1/30/2026 20:08'!
gtSummaryFor: aView
	<gtView>
	^ aView columnedList
		title: 'Summary';
		priority: 10;
		items: [ {{'ID'.
					self id}.
				{'Paper'.
					self paper} .
				{'Abstract'.
					self abstract} .
				{'Venue'.
					self venue} }];
		column: 'Key'
			text: #first
			width: 100;
		column: 'Value' text: #second;
		send: #last;
		actionUpdateButton! !


!VRDesignStudy methodsFor: 'views' stamp: '1/30/2026 20:08'!
gtJsonFor: aView
	<gtView>
	^ aView forward
		title: 'Json';
		priority: 20;
		object: [ self data ];
		view: #gtItemsFor:! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VRDesignStudy class
	instanceVariableNames: ''!

!VRDesignStudy class methodsFor: 'instance creation' stamp: '1/30/2026 20:08'!
for: aDictionary in: aDataset
	^ self new
		data: aDictionary;
		dataset: aDataset;
		yourself! !
