Object subclass: #Price
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'EDDPrices'!

!Price methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 17:17'!
money
	^ self subclassResponsibility! !

!Price methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 17:26'!
gtMoneyFor: aView
	<gtView>
	^ aView forward
		title: 'Money';
		priority: 10;
		object: [ self money ];
		view: #gtDetailsFor:! !

!Price methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 17:38'!
discountedBy: aMoneyOrPercent 
	^ aMoneyOrPercent discountFrom: self! !

!Price methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 17:17'!
= other
	^ self money = other money! !


Price subclass: #ConcretePrice
	instanceVariableNames: 'money'
	classVariableNames: ''
	package: 'EDDPrices'!

!ConcretePrice methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 10:48'!
money
	^ money! !

!ConcretePrice methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 10:27'!
money: aMoney
	money := aMoney! !


Price subclass: #DecoratedPrice
	instanceVariableNames: 'price'
	classVariableNames: ''
	package: 'EDDPrices'!

!DecoratedPrice methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 17:50'!
price
	^ price! !

!DecoratedPrice methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 17:50'!
price: aPrice
	price := aPrice! !


DecoratedPrice subclass: #PriceDiscountedByMoney
	instanceVariableNames: 'discountMoney'
	classVariableNames: ''
	package: 'EDDPrices'!

!PriceDiscountedByMoney methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 17:21'!
money
	^ self price money - self discountMoney! !

!PriceDiscountedByMoney methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 17:21'!
discountMoney
	^ discountMoney! !

!PriceDiscountedByMoney methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 15:13'!
discountMoney: aMoney
	discountMoney := aMoney! !


DecoratedPrice subclass: #PriceDiscountedByPercent
	instanceVariableNames: 'discountPercent'
	classVariableNames: ''
	package: 'EDDPrices'!

!PriceDiscountedByPercent methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 17:54'!
money
	^ self price money * (1 - self discountPercent)! !

!PriceDiscountedByPercent methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 17:52'!
discountPercent: anObject
	discountPercent := anObject! !

!PriceDiscountedByPercent methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 17:52'!
discountPercent
	^ discountPercent! !


Object subclass: #PricesExamples
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'EDDPrices'!

!PricesExamples methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 17:59'!
priceDiscountedByPercent
	<gtExample>
	| price priceDiscountedByMoney |
	priceDiscountedByMoney := self priceDiscountedByMoney.
	price := priceDiscountedByMoney discountedBy: 10 percent.
	self assert: price equals: 81 euros asPrice.
	^ price! !

!PricesExamples methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 10:54'!
concretePrice
	<gtExample>
	| aPrice |
	aPrice := 100 euros asPrice.
	self assert: aPrice equals: 100 euros asPrice.
	^ aPrice! !

!PricesExamples methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 17:23'!
priceDiscountedByMoney
	<gtExample>
	| price priceDiscountedByMoney |
	price := self concretePrice.
	priceDiscountedByMoney := price discountedBy: 10 euros.
	self assert: priceDiscountedByMoney equals: 90 euros asPrice.
	^ priceDiscountedByMoney! !
'From Pharo10.0.0 of 15 March 2023 [Build information: Pharo-10.0.0+build.538.sha.179ef655ae2b150009a860b127aa3605366659ca (64 Bit)] on 13 February 2024 at 6:02:18.532202 pm'!

!Fraction methodsFor: '*EDDPrices' stamp: 'GlamorousAuthor 2/13/2024 17:56'!
discountFrom: aPrice
	^ PriceDiscountedByPercent new
		price: aPrice;
		discountPercent: self! !
'From Pharo10.0.0 of 15 March 2023 [Build information: Pharo-10.0.0+build.538.sha.179ef655ae2b150009a860b127aa3605366659ca (64 Bit)] on 13 February 2024 at 6:02:18.532843 pm'!

!GtTCurrencyMoney methodsFor: '*EDDPrices' stamp: 'GlamorousAuthor 2/13/2024 10:32'!
asPrice
	^ ConcretePrice new money: self! !
'From Pharo10.0.0 of 15 March 2023 [Build information: Pharo-10.0.0+build.538.sha.179ef655ae2b150009a860b127aa3605366659ca (64 Bit)] on 13 February 2024 at 6:02:18.533431 pm'!

!GtTMoney methodsFor: '*EDDPrices' stamp: 'GlamorousAuthor 2/13/2024 17:40'!
discountFrom: aPrice
	^ PriceDiscountedByMoney new
		price: aPrice;
		discountMoney: self! !
