Object subclass: #Price
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'EDDPrices'!

!Price methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/17/2024 10:03'!
= other
	^ self money = other money! !

!Price methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/17/2024 10:01'!
gtMoneyFor: aView
	<gtView>
	^ aView forward
		title: 'Money';
		priority: 10;
		object: [ self money ];
		view: #gtDetailsFor:! !

!Price methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/17/2024 10:19'!
discountedBy: aMoneyOrPercent 
	^ aMoneyOrPercent discountFrom: self! !

!Price methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/17/2024 10:01'!
money
	self subclassResponsibility! !


Price subclass: #ConcretePrice
	instanceVariableNames: 'money'
	classVariableNames: ''
	package: 'EDDPrices'!

!ConcretePrice methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/17/2024 10:04'!
money: aMoney
	money := aMoney! !

!ConcretePrice methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 10:48'!
money
	^ money! !


Price subclass: #PriceDiscountedByMoney
	instanceVariableNames: 'price discountMoney'
	classVariableNames: ''
	package: 'EDDPrices'!

!PriceDiscountedByMoney methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/17/2024 09:56'!
discountMoney: aMoney
	discountMoney := aMoney! !

!PriceDiscountedByMoney methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/17/2024 09:56'!
price: aPrice
	price :=aPrice! !

!PriceDiscountedByMoney methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/17/2024 09:57'!
money
	^ price money - discountMoney! !


PriceDiscountedByMoney subclass: #PriceDiscountedByPercent
	instanceVariableNames: 'discountPercent'
	classVariableNames: ''
	package: 'EDDPrices'!

!PriceDiscountedByPercent methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/17/2024 10:21'!
discountPercent: aPercent
	discountPercent := aPercent! !

!PriceDiscountedByPercent methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/17/2024 10:24'!
money
	^ price money * (1 - discountPercent)! !


Object subclass: #PricesExamples
	instanceVariableNames: ''
	classVariableNames: ''
	package: 'EDDPrices'!

!PricesExamples methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/13/2024 10:54'!
concretePrice
	<gtExample>
	| aPrice |
	aPrice := 100 euros asPrice.
	self assert: aPrice equals: 100 euros asPrice.
	^ aPrice! !

!PricesExamples methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/17/2024 10:14'!
priceDiscountedByMoney
	<gtExample>
	| price discountedPrice |
	price := self concretePrice.
	discountedPrice := price discountedBy: 10 euros.
	self assert: discountedPrice equals: 90 euros asPrice.
	^ discountedPrice! !

!PricesExamples methodsFor: 'accessing' stamp: 'GlamorousAuthor 2/17/2024 10:28'!
priceDiscountedByPercent
	<gtExample>
	| priceDiscountedByMoney priceDiscountedByPercent |
	priceDiscountedByMoney := self priceDiscountedByMoney.
	priceDiscountedByPercent := priceDiscountedByMoney discountedBy: 10 percent.
	self assert: priceDiscountedByPercent 
			equals: 81 euros asPrice.
	^ priceDiscountedByPercent! !
'From Pharo10.0.0 of 15 March 2023 [Build information: Pharo-10.0.0+build.538.sha.179ef655ae2b150009a860b127aa3605366659ca (64 Bit)] on 17 February 2024 at 10:28:49.207274 am'!

!Fraction methodsFor: '*EDDPrices' stamp: 'GlamorousAuthor 2/17/2024 10:25'!
discountFrom: aPrice
	^ PriceDiscountedByPercent new
		price: aPrice;
		discountPercent: self! !
'From Pharo10.0.0 of 15 March 2023 [Build information: Pharo-10.0.0+build.538.sha.179ef655ae2b150009a860b127aa3605366659ca (64 Bit)] on 17 February 2024 at 10:28:49.207838 am'!

!GtTCurrencyMoney methodsFor: '*EDDPrices' stamp: 'GlamorousAuthor 2/13/2024 10:32'!
asPrice
	^ ConcretePrice new money: self! !
'From Pharo10.0.0 of 15 March 2023 [Build information: Pharo-10.0.0+build.538.sha.179ef655ae2b150009a860b127aa3605366659ca (64 Bit)] on 17 February 2024 at 10:28:49.208348 am'!

!GtTMoney methodsFor: '*EDDPrices' stamp: 'GlamorousAuthor 2/17/2024 10:18'!
discountFrom: aPrice
	^ PriceDiscountedByMoney new
		price: aPrice;
		discountMoney: self! !
